/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Item;
import hudson.model.Job;
import java.io.IOException;
import java.net.URI;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.CollaboratorService;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedGitHubClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GitHubHelper.class);

    private GitHubHelper() {
    }

    public static Boolean isAuthorized(@NonNull Job<?, ?> job, @NonNull String User2) {
        ExtendedGitHubClient client = GitHubHelper.getGitHubClient(job);
        RepositoryId repository = GitHubHelper.getRepositoryId(job);
        CollaboratorService collaboratorService = new CollaboratorService((GitHubClient)client);
        try {
            return collaboratorService.isCollaborator((IRepositoryIdProvider)repository, User2);
        }
        catch (IOException e) {
            LOG.debug("Received an exception while trying to check if user {} is a collaborator of repository: {}", new Object[]{User2, repository, e});
            return false;
        }
    }

    public static ExtendedGitHubClient getGitHubClient(@NonNull Job<?, ?> job) {
        SCMSource scmSource = SCMSource.SourceByItem.findSource(job);
        if (scmSource instanceof GitHubSCMSource) {
            StandardCredentials credentials;
            GitHubSCMSource gitHubSource = (GitHubSCMSource)scmSource;
            URI uri = URI.create(gitHubSource.getApiUri());
            ExtendedGitHubClient client = new ExtendedGitHubClient(uri.getHost(), uri.getPort(), uri.getScheme());
            if (gitHubSource.getCredentialsId() != null && (credentials = Connector.lookupScanCredentials(job, (String)gitHubSource.getApiUri(), (String)gitHubSource.getCredentialsId(), (String)gitHubSource.getRepoOwner())) instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
                String userName = c.getUsername();
                String password = c.getPassword().getPlainText();
                client.setCredentials(userName, password);
            }
            return client;
        }
        throw new IllegalArgumentException("Job's SCM is not GitHub.");
    }

    public static RepositoryId getRepositoryId(@NonNull Job<?, ?> job) {
        GitHubSCMSource source;
        SCMSource src = SCMSource.SourceByItem.findSource(job);
        if (src instanceof GitHubSCMSource && (source = (GitHubSCMSource)src).getCredentialsId() != null) {
            return RepositoryId.create((String)source.getRepoOwner(), (String)source.getRepository());
        }
        return null;
    }

    public static PullRequestSCMHead getPullRequest(@NonNull Job job) throws Exception {
        PullRequestSCMHead head = (PullRequestSCMHead)SCMHead.HeadByItem.findHead((Item)job);
        if (head == null) {
            throw new IllegalStateException("Build is not a Pull Request");
        }
        return head;
    }

    public static String userToLogin(User user) {
        return user == null ? null : user.getLogin();
    }

    public static Job getJob(String jobId) {
        Job job = (Job)Jenkins.get().getItemByFullName(jobId, Job.class);
        if (job == null) {
            throw new IllegalStateException("Unable to find Job: " + jobId);
        }
        return job;
    }
}

