/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github;

import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.egit.github.core.Commit;
import org.eclipse.egit.github.core.CommitStatus;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.RepositoryCommit;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.User;
import org.jenkinsci.plugins.pipeline.github.CommitFileGroovyObject;
import org.jenkinsci.plugins.pipeline.github.CommitStatusGroovyObject;
import org.jenkinsci.plugins.pipeline.github.GitHubHelper;
import org.jenkinsci.plugins.pipeline.github.ReviewCommentGroovyObject;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitComment;
import org.jenkinsci.plugins.pipeline.github.client.ExtendedCommitService;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class CommitGroovyObject
extends GroovyObjectSupport
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String jobId;
    private final RepositoryCommit commit;
    private final RepositoryId base;
    private transient ExtendedCommitService commitService;

    CommitGroovyObject(String jobId, RepositoryCommit commit, ExtendedCommitService commitService, RepositoryId base) {
        this.jobId = Objects.requireNonNull(jobId, "jobId cannot be null");
        this.commit = Objects.requireNonNull(commit, "commit cannot be null");
        this.commitService = Objects.requireNonNull(commitService, "commitService cannot be null");
        this.base = Objects.requireNonNull(base, "base cannot be null");
    }

    private ExtendedCommitService getCommitService() {
        if (this.commitService == null) {
            this.commitService = new ExtendedCommitService(GitHubHelper.getGitHubClient(GitHubHelper.getJob(this.jobId)));
        }
        return this.commitService;
    }

    @Whitelisted
    public String getSha() {
        return this.commit.getSha();
    }

    @Whitelisted
    public String getUrl() {
        return this.commit.getUrl();
    }

    @Whitelisted
    public String getAuthor() {
        return Optional.ofNullable(this.commit.getAuthor()).map(User::getLogin).orElse(null);
    }

    @Whitelisted
    public String getCommitter() {
        return Optional.ofNullable(this.commit.getCommitter()).map(User::getLogin).orElse(null);
    }

    @Whitelisted
    public String getMessage() {
        return this.commit.getCommit().getMessage();
    }

    @Whitelisted
    public int getCommentCount() {
        return this.commit.getCommit().getCommentCount();
    }

    @Whitelisted
    public int getAdditions() {
        return this.commit.getStats().getAdditions();
    }

    @Whitelisted
    public int getDeletions() {
        return this.commit.getStats().getDeletions();
    }

    @Whitelisted
    public int getTotalChanges() {
        return this.commit.getStats().getTotal();
    }

    @Whitelisted
    public Iterable<ReviewCommentGroovyObject> getComments() {
        Stream<ReviewCommentGroovyObject> stream = StreamSupport.stream(this.getCommitService().pageComments2((IRepositoryIdProvider)this.base, this.commit.getSha()).spliterator(), false).flatMap(Collection::stream).map(c -> new ReviewCommentGroovyObject(this.jobId, this.base, (ExtendedCommitComment)((Object)c), this.commitService));
        return stream::iterator;
    }

    @Whitelisted
    public Iterable<CommitStatusGroovyObject> getStatuses() {
        try {
            return this.getCommitService().getStatuses((IRepositoryIdProvider)this.base, this.commit.getSha()).stream().map(CommitStatusGroovyObject::new).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public Iterable<String> getParents() {
        return this.commit.getParents().stream().map(Commit::getSha).collect(Collectors.toList());
    }

    @Whitelisted
    public Iterable<CommitFileGroovyObject> getFiles() {
        return Optional.ofNullable(this.commit.getFiles()).orElseGet(Collections::emptyList).stream().map(CommitFileGroovyObject::new).collect(Collectors.toList());
    }

    @Whitelisted
    public ReviewCommentGroovyObject comment(Map<String, Object> params) {
        Objects.requireNonNull(params.get("body"), "body is a required argument");
        return this.comment(params.get("body").toString(), params.get("path") != null ? params.get("path").toString() : null, (Integer)params.get("position"));
    }

    @Whitelisted
    public ReviewCommentGroovyObject comment(String body, String path, Integer position) {
        Objects.requireNonNull(body, "body is a required argument");
        ExtendedCommitComment comment = new ExtendedCommitComment();
        comment.setBody(body);
        comment.setPath(path);
        comment.setPosition(position);
        try {
            return new ReviewCommentGroovyObject(this.jobId, this.base, this.getCommitService().addComment((IRepositoryIdProvider)this.base, this.commit.getSha(), comment), this.getCommitService());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Whitelisted
    public CommitStatusGroovyObject createStatus(Map<String, Object> params) {
        Objects.requireNonNull(params.get("status"), "status is a required argument");
        return this.createStatus(params.get("status").toString(), params.get("context") != null ? params.get("context").toString() : null, params.get("description") != null ? params.get("description").toString() : null, params.get("targetUrl") != null ? params.get("targetUrl").toString() : null);
    }

    @Whitelisted
    public CommitStatusGroovyObject createStatus(String status, String context, String description, String targetUrl) {
        Objects.requireNonNull(status, "status is a required argument");
        CommitStatus commitStatus = new CommitStatus();
        commitStatus.setState(status);
        commitStatus.setContext(context);
        commitStatus.setDescription(description);
        commitStatus.setTargetUrl(targetUrl);
        try {
            return new CommitStatusGroovyObject(this.getCommitService().createStatus((IRepositoryIdProvider)this.base, this.commit.getSha(), commitStatus));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

