/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.github.library;

import hudson.Extension;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import jenkins.plugins.git.GitSCMSource;
import jenkins.plugins.git.traits.IgnoreOnPushNotificationTrait;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.workflow.libs.LibraryConfiguration;
import org.jenkinsci.plugins.workflow.libs.LibraryResolver;
import org.jenkinsci.plugins.workflow.libs.LibraryRetriever;
import org.jenkinsci.plugins.workflow.libs.SCMSourceRetriever;

@Extension
public class GitHubLibraryResolver
extends LibraryResolver {
    public boolean isTrusted() {
        return false;
    }

    public Collection<LibraryConfiguration> forJob(Job<?, ?> job, Map<String, String> libraryVersions) {
        ArrayList<LibraryConfiguration> libs = new ArrayList<LibraryConfiguration>();
        for (Map.Entry<String, String> entry : libraryVersions.entrySet()) {
            if (!entry.getKey().matches("github[.]com/([^/]+)/([^/]+)")) continue;
            String name = entry.getKey();
            GitSCMSource scm = new GitSCMSource("https://" + name + ".git");
            scm.setTraits(Arrays.asList(new IgnoreOnPushNotificationTrait()));
            LibraryConfiguration lib = new LibraryConfiguration(name, (LibraryRetriever)new SCMSourceRetriever((SCMSource)scm));
            lib.setDefaultVersion("master");
            libs.add(lib);
        }
        return libs;
    }
}

