/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ItemVisitor;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PasswordParameterDefinition;
import hudson.model.PasswordParameterValue;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.jenkinsci.plugins.structs.describable.CustomDescribableModel;
import org.jenkinsci.plugins.structs.describable.DescribableModel;
import org.jenkinsci.plugins.structs.describable.UninstantiatedDescribable;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.steps.build.BuildTriggerStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.build.Messages;
import org.jenkinsci.plugins.workflow.util.StaplerReferer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class BuildTriggerStep
extends Step {
    private final String job;
    private List<ParameterValue> parameters;
    private boolean wait = true;
    private boolean waitForStart = false;
    private boolean propagate = true;
    private Integer quietPeriod;

    @DataBoundConstructor
    public BuildTriggerStep(String job) {
        this.job = job;
    }

    public String getJob() {
        return this.job;
    }

    public List<ParameterValue> getParameters() {
        return this.parameters;
    }

    @DataBoundSetter
    public void setParameters(List<ParameterValue> parameters) {
        this.parameters = parameters;
    }

    public boolean getWait() {
        return this.wait;
    }

    @DataBoundSetter
    public void setWait(boolean wait) {
        this.wait = wait;
    }

    public boolean getWaitForStart() {
        return this.waitForStart;
    }

    @DataBoundSetter
    public void setWaitForStart(boolean waitForStart) {
        this.waitForStart = waitForStart;
    }

    public Integer getQuietPeriod() {
        return this.quietPeriod;
    }

    @DataBoundSetter
    public void setQuietPeriod(Integer quietPeriod) {
        this.quietPeriod = quietPeriod;
    }

    public boolean isPropagate() {
        return this.propagate;
    }

    @DataBoundSetter
    public void setPropagate(boolean propagate) {
        this.propagate = propagate;
    }

    public StepExecution start(StepContext context) {
        return new BuildTriggerStepExecution(this, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor
    implements CustomDescribableModel {
        public Step newInstance(@Nullable StaplerRequest2 req, @NonNull JSONObject formData) throws Descriptor.FormException {
            JSONArray params;
            BuildTriggerStep step = (BuildTriggerStep)super.newInstance(req, formData);
            Object parameter = formData.get("parameter");
            JSONArray jSONArray = params = parameter != null ? JSONArray.fromObject((Object)parameter) : null;
            if (params != null) {
                ParametersDefinitionProperty pdp;
                Job context = (Job)StaplerReferer.findItemFromRequest(Job.class);
                Job job = (Job)Jenkins.get().getItem(step.getJob(), (Item)context, Job.class);
                if (job != null && (pdp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class)) != null) {
                    ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
                    for (Object o : params) {
                        ParameterValue parameterValue;
                        JSONObject jo = (JSONObject)o;
                        String name = jo.getString("name");
                        ParameterDefinition d = pdp.getParameterDefinition(name);
                        if (d == null) {
                            throw new IllegalArgumentException("No such parameter definition: " + name);
                        }
                        if (d instanceof PasswordParameterDefinition) {
                            parameterValue = (ParameterValue)req.bindJSON(PasswordParameterValue.class, jo);
                            parameterValue.setDescription(d.getDescription());
                        } else {
                            parameterValue = d.createValue(req, jo);
                        }
                        if (parameterValue != null) {
                            values.add(parameterValue);
                            continue;
                        }
                        throw new IllegalArgumentException("Cannot retrieve the parameter value: " + name);
                    }
                    step.setParameters(values);
                }
            }
            return step;
        }

        @NonNull
        public Map<String, Object> customInstantiate(@NonNull Map<String, Object> map) {
            if (DescribableModel.of(PasswordParameterValue.class).getParameter("value").getErasedType() != Secret.class) {
                return map;
            }
            return DescriptorImpl.copyMapReplacingEntry(map, "parameters", List.class, parameters -> parameters.stream().map(parameter -> {
                UninstantiatedDescribable ud;
                if (parameter instanceof UninstantiatedDescribable && (ud = (UninstantiatedDescribable)parameter).getSymbol().equals("password")) {
                    Map<String, Object> newArguments = DescriptorImpl.copyMapReplacingEntry(ud.getArguments(), "value", String.class, Secret::fromString);
                    return ud.withArguments(newArguments);
                }
                return parameter;
            }).collect(Collectors.toList()));
        }

        @NonNull
        public UninstantiatedDescribable customUninstantiate(@NonNull UninstantiatedDescribable step) {
            Map<String, Object> newStepArgs = DescriptorImpl.copyMapReplacingEntry(step.getArguments(), "parameters", List.class, parameters -> parameters.stream().map(parameter -> {
                UninstantiatedDescribable ud;
                if (parameter instanceof UninstantiatedDescribable && (ud = (UninstantiatedDescribable)parameter).getSymbol().equals("password")) {
                    Map<String, Object> newParamArgs = DescriptorImpl.copyMapReplacingEntry(ud.getArguments(), "value", Secret.class, Secret::getPlainText);
                    return ud.withArguments(newParamArgs);
                }
                return parameter;
            }).collect(Collectors.toList()));
            return step.withArguments(newStepArgs);
        }

        private static <T> Map<String, Object> copyMapReplacingEntry(Map<String, ?> map, String keyToReplace, Class<T> requiredValueType, Function<T, Object> replacer) {
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                if (entry.getKey().equals(keyToReplace) && requiredValueType.isInstance(entry.getValue())) {
                    newMap.put(entry.getKey(), replacer.apply(requiredValueType.cast(entry.getValue())));
                    continue;
                }
                newMap.put(entry.getKey(), entry.getValue());
            }
            return newMap;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            HashSet context = new HashSet();
            Collections.addAll(context, FlowNode.class, Run.class, TaskListener.class);
            return Collections.unmodifiableSet(context);
        }

        public String getFunctionName() {
            return "build";
        }

        @NonNull
        public String getDisplayName() {
            return "Build a job";
        }

        public AutoCompletionCandidates doAutoCompleteJob(@AncestorInPath ItemGroup<?> container, final @QueryParameter String value) {
            class Visitor
            extends ItemVisitor {
                String prefix;
                final /* synthetic */ DescriptorImpl this$0;

                Visitor(String prefix) {
                    this.this$0 = this$0;
                    this.prefix = prefix;
                }

                public void onItem(Item i) {
                    String n = this.contextualNameOf(i);
                    if ((n.startsWith(value) || value.startsWith(n)) && (value.length() > n.length() || !n.substring(value.length()).contains("/")) && i.hasPermission(Item.READ)) {
                        if (i instanceof Queue.Task && n.startsWith(value)) {
                            candidates.add(n);
                        }
                        String oldPrefix = this.prefix;
                        this.prefix = n;
                        super.onItem(i);
                        this.prefix = oldPrefix;
                    }
                }

                private String contextualNameOf(Item i) {
                    if (this.prefix.endsWith("/") || this.prefix.length() == 0) {
                        return this.prefix + i.getName();
                    }
                    return this.prefix + "/" + i.getName();
                }
            }
            final AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            if (container == null || container == Jenkins.getInstanceOrNull()) {
                new Visitor("").onItemGroup((ItemGroup)Jenkins.getInstanceOrNull());
            } else {
                new Visitor("").onItemGroup(container);
                if (value.startsWith("/")) {
                    new Visitor("/").onItemGroup((ItemGroup)Jenkins.getInstanceOrNull());
                }
                StringBuilder p = new StringBuilder("../");
                while (value.startsWith(p.toString())) {
                    container = ((Item)container).getParent();
                    new Visitor(p.toString()).onItemGroup(container);
                    p.append("../");
                }
            }
            return candidates;
        }

        @Restricted(value={DoNotUse.class})
        public String getContext() {
            Job job = (Job)StaplerReferer.findItemFromRequest(Job.class);
            return job != null ? job.getFullName() : null;
        }

        @Restricted(value={DoNotUse.class})
        public String getContextEncoded() {
            String context = this.getContext();
            return context != null ? StringEscapeUtils.escapeEcmaScript((String)context) : null;
        }

        public FormValidation doCheckPropagate(@QueryParameter boolean value, @QueryParameter boolean wait) {
            if (!value && !wait) {
                return FormValidation.warningWithMarkup((String)Messages.BuildTriggerStep_explicitly_disabling_both_propagate_and_wait());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWait(@AncestorInPath ItemGroup<?> context, @QueryParameter boolean value, @QueryParameter String job) {
            if (!value) {
                return FormValidation.ok();
            }
            Item item = Jenkins.get().getItem(job, context, Item.class);
            if (item == null) {
                return FormValidation.ok();
            }
            if (item instanceof Job) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BuildTriggerStep_no_wait_for_non_jobs());
        }

        public FormValidation doCheckJob(@AncestorInPath ItemGroup<?> context, @QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.warning((String)Messages.BuildTriggerStep_no_job_configured());
            }
            Item item = Jenkins.get().getItem(value, context, Item.class);
            if (item == null) {
                return FormValidation.error((String)Messages.BuildTriggerStep_cannot_find(value));
            }
            if (item instanceof Queue.Task) {
                return FormValidation.ok();
            }
            if (item instanceof Describable) {
                return FormValidation.error((String)Messages.BuildTriggerStep_unsupported(((Describable)item).getDescriptor().getDisplayName()));
            }
            return FormValidation.error((String)Messages.BuildTriggerStep_unsupported(item.getClass().getName()));
        }
    }
}

