/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflow.support.steps.build;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import jenkins.model.CauseOfInterruption;
import jenkins.model.Jenkins;

public final class DownstreamFailureCause
extends CauseOfInterruption {
    private static final long serialVersionUID = 1L;
    private final String jobFullName;
    private final int buildNumber;
    private final String url;
    private final Result result;
    @Deprecated
    private String id;

    DownstreamFailureCause(Run<?, ?> downstream) {
        this.jobFullName = downstream.getParent().getFullName();
        this.buildNumber = downstream.getNumber();
        this.url = downstream.getUrl();
        this.result = downstream.getResult();
    }

    @CheckForNull
    public Run<?, ?> getDownstreamBuild() {
        if (this.id != null) {
            return Run.fromExternalizableId((String)this.id);
        }
        Job job = (Job)Jenkins.get().getItemByFullName(this.jobFullName, Job.class);
        return job != null ? job.getBuildByNumber(this.buildNumber) : null;
    }

    public void print(TaskListener listener) {
        Run<?, ?> downstream;
        String description = this.id != null ? ((downstream = this.getDownstreamBuild()) != null ? this.description(ModelHyperlinkNote.encodeTo((String)("/" + downstream.getUrl()), (String)downstream.getFullDisplayName()), downstream.getResult()) : "Downstream build was not stable (propagate: false to ignore)") : this.description(ModelHyperlinkNote.encodeTo((String)("/" + this.url), (String)(this.jobFullName + " #" + this.buildNumber)), this.result);
        listener.getLogger().println(description);
    }

    public String getShortDescription() {
        if (this.id != null) {
            Run<?, ?> downstream = this.getDownstreamBuild();
            if (downstream != null) {
                return this.description(downstream.getFullDisplayName(), downstream.getResult());
            }
            return "Downstream build was not stable (propagate: false to ignore)";
        }
        return this.description(this.jobFullName + " #" + this.buildNumber, this.result);
    }

    private String description(String downstreamBuildDescription, Result downstreamResult) {
        return downstreamBuildDescription + " completed with status " + String.valueOf(downstreamResult) + " (propagate: false to ignore)";
    }
}

