// CHECKSTYLE:OFF

package org.jenkinsci.plugins.workflow.support.steps.build;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code BuildTriggerStep.no_wait_for_non_jobs}: {@code Waiting for
     * non-job items is not supported}.
     * 
     * @return
     *     {@code Waiting for non-job items is not supported}
     */
    public static String BuildTriggerStep_no_wait_for_non_jobs() {
        return holder.format("BuildTriggerStep.no_wait_for_non_jobs");
    }

    /**
     * Key {@code BuildTriggerStep.no_wait_for_non_jobs}: {@code Waiting for
     * non-job items is not supported}.
     * 
     * @return
     *     {@code Waiting for non-job items is not supported}
     */
    public static Localizable _BuildTriggerStep_no_wait_for_non_jobs() {
        return new Localizable(holder, "BuildTriggerStep.no_wait_for_non_jobs");
    }

    /**
     * Key {@code BuildTriggerStepExecution.convertedParameterDescription}:
     * {@code {0} (Automatically converted to {1} because {2} passed the
     * parameter using a different type)}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} (Automatically converted to {1} because {2} passed the
     *     parameter using a different type)}
     */
    public static String BuildTriggerStepExecution_convertedParameterDescription(Object arg0, Object arg1, Object arg2) {
        return holder.format("BuildTriggerStepExecution.convertedParameterDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code BuildTriggerStepExecution.convertedParameterDescription}:
     * {@code {0} (Automatically converted to {1} because {2} passed the
     * parameter using a different type)}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} (Automatically converted to {1} because {2} passed the
     *     parameter using a different type)}
     */
    public static Localizable _BuildTriggerStepExecution_convertedParameterDescription(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "BuildTriggerStepExecution.convertedParameterDescription", arg0, arg1, arg2);
    }

    /**
     * Key {@code
     * BuildTriggerStep.explicitly_disabling_both_propagate_and_wait}: {@code
     * Explicitly disabling both <code>propagate</code> and <code>wait</code>
     * is redundant, since <code>propagate</code> is ignored when
     * <code>wait</code> is disabled. For brevity, leave
     * <code>propagate</code> at its default.}.
     * 
     * @return
     *     {@code Explicitly disabling both <code>propagate</code> and
     *     <code>wait</code> is redundant, since <code>propagate</code> is
     *     ignored when <code>wait</code> is disabled. For brevity, leave
     *     <code>propagate</code> at its default.}
     */
    public static String BuildTriggerStep_explicitly_disabling_both_propagate_and_wait() {
        return holder.format("BuildTriggerStep.explicitly_disabling_both_propagate_and_wait");
    }

    /**
     * Key {@code
     * BuildTriggerStep.explicitly_disabling_both_propagate_and_wait}: {@code
     * Explicitly disabling both <code>propagate</code> and <code>wait</code>
     * is redundant, since <code>propagate</code> is ignored when
     * <code>wait</code> is disabled. For brevity, leave
     * <code>propagate</code> at its default.}.
     * 
     * @return
     *     {@code Explicitly disabling both <code>propagate</code> and
     *     <code>wait</code> is redundant, since <code>propagate</code> is
     *     ignored when <code>wait</code> is disabled. For brevity, leave
     *     <code>propagate</code> at its default.}
     */
    public static Localizable _BuildTriggerStep_explicitly_disabling_both_propagate_and_wait() {
        return new Localizable(holder, "BuildTriggerStep.explicitly_disabling_both_propagate_and_wait");
    }

    /**
     * Key {@code BuildTriggerStepExecution.building_}: {@code Building {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building {0}}
     */
    public static String BuildTriggerStepExecution_building_(Object arg0) {
        return holder.format("BuildTriggerStepExecution.building_", arg0);
    }

    /**
     * Key {@code BuildTriggerStepExecution.building_}: {@code Building {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building {0}}
     */
    public static Localizable _BuildTriggerStepExecution_building_(Object arg0) {
        return new Localizable(holder, "BuildTriggerStepExecution.building_", arg0);
    }

    /**
     * Key {@code BuildTriggerStep.unsupported}: {@code Building a {0} is not
     * supported}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building a {0} is not supported}
     */
    public static String BuildTriggerStep_unsupported(Object arg0) {
        return holder.format("BuildTriggerStep.unsupported", arg0);
    }

    /**
     * Key {@code BuildTriggerStep.unsupported}: {@code Building a {0} is not
     * supported}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Building a {0} is not supported}
     */
    public static Localizable _BuildTriggerStep_unsupported(Object arg0) {
        return new Localizable(holder, "BuildTriggerStep.unsupported", arg0);
    }

    /**
     * Key {@code WaitForBuildStep.cannot_find}: {@code No such run with
     * externalizable id {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such run with externalizable id {0}}
     */
    public static String WaitForBuildStep_cannot_find(Object arg0) {
        return holder.format("WaitForBuildStep.cannot_find", arg0);
    }

    /**
     * Key {@code WaitForBuildStep.cannot_find}: {@code No such run with
     * externalizable id {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such run with externalizable id {0}}
     */
    public static Localizable _WaitForBuildStep_cannot_find(Object arg0) {
        return new Localizable(holder, "WaitForBuildStep.cannot_find", arg0);
    }

    /**
     * Key {@code WaitForBuildStepExecution.waitfor}: {@code Wait for {0} to
     * complete}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Wait for {0} to complete}
     */
    public static String WaitForBuildStepExecution_waitfor(Object arg0) {
        return holder.format("WaitForBuildStepExecution.waitfor", arg0);
    }

    /**
     * Key {@code WaitForBuildStepExecution.waitfor}: {@code Wait for {0} to
     * complete}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Wait for {0} to complete}
     */
    public static Localizable _WaitForBuildStepExecution_waitfor(Object arg0) {
        return new Localizable(holder, "WaitForBuildStepExecution.waitfor", arg0);
    }

    /**
     * Key {@code BuildTriggerStep.no_job_configured}: {@code No job
     * configured}.
     * 
     * @return
     *     {@code No job configured}
     */
    public static String BuildTriggerStep_no_job_configured() {
        return holder.format("BuildTriggerStep.no_job_configured");
    }

    /**
     * Key {@code BuildTriggerStep.no_job_configured}: {@code No job
     * configured}.
     * 
     * @return
     *     {@code No job configured}
     */
    public static Localizable _BuildTriggerStep_no_job_configured() {
        return new Localizable(holder, "BuildTriggerStep.no_job_configured");
    }

    /**
     * Key {@code BuildTriggerStepExecution.scheduling}: {@code Scheduling
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Scheduling {0}}
     */
    public static String BuildTriggerStepExecution_scheduling(Object arg0) {
        return holder.format("BuildTriggerStepExecution.scheduling", arg0);
    }

    /**
     * Key {@code BuildTriggerStepExecution.scheduling}: {@code Scheduling
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Scheduling {0}}
     */
    public static Localizable _BuildTriggerStepExecution_scheduling(Object arg0) {
        return new Localizable(holder, "BuildTriggerStepExecution.scheduling", arg0);
    }

    /**
     * Key {@code BuildTriggerStep.cannot_find}: {@code No such job {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job {0}}
     */
    public static String BuildTriggerStep_cannot_find(Object arg0) {
        return holder.format("BuildTriggerStep.cannot_find", arg0);
    }

    /**
     * Key {@code BuildTriggerStep.cannot_find}: {@code No such job {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such job {0}}
     */
    public static Localizable _BuildTriggerStep_cannot_find(Object arg0) {
        return new Localizable(holder, "BuildTriggerStep.cannot_find", arg0);
    }

    /**
     * Key {@code WaitForBuildStep.no_run_configured}: {@code No runId
     * configured}.
     * 
     * @return
     *     {@code No runId configured}
     */
    public static String WaitForBuildStep_no_run_configured() {
        return holder.format("WaitForBuildStep.no_run_configured");
    }

    /**
     * Key {@code WaitForBuildStep.no_run_configured}: {@code No runId
     * configured}.
     * 
     * @return
     *     {@code No runId configured}
     */
    public static Localizable _WaitForBuildStep_no_run_configured() {
        return new Localizable(holder, "WaitForBuildStep.no_run_configured");
    }

}
