/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.collect.Sets;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.jenkinsci.plugins.periodicbackup.StorageDescriptor;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

public class ZipStorage
extends Storage {
    private static final int MAX_FILES_PER_ARCHIVE = 65534;
    private static final long MAX_SIZE_OF_FILES_PER_ARCHIVE = 3999999999L;
    private boolean multiVolume;
    private long volumeSize;
    private static final Logger LOGGER = Logger.getLogger(ZipStorage.class.getName());
    private transient ZipArchiver archiver;
    private transient File tempDirectory;
    private transient String archiveFilePathBase;
    private transient long currentArchiveTotalFilesSize;
    private transient int currentArchiveFilesCount;
    private transient int archivesNumber;
    private transient Set<File> archives;

    @DataBoundConstructor
    public ZipStorage(boolean multiVolume, long volumeSize) {
        this.multiVolume = multiVolume;
        this.volumeSize = volumeSize;
    }

    public long getCurrentArchiveTotalFilesSize() {
        return this.currentArchiveTotalFilesSize;
    }

    public ZipArchiver getArchiver() {
        return this.archiver;
    }

    public int getCurrentArchiveFilesCount() {
        return this.currentArchiveFilesCount;
    }

    public int getArchivesNumber() {
        return this.archivesNumber;
    }

    public long getVolumeSize() {
        return this.volumeSize;
    }

    public void setVolumeSize(long volumeSize) {
        this.volumeSize = volumeSize;
    }

    public boolean isMultiVolume() {
        return this.multiVolume;
    }

    public void setMultiVolume(boolean multiVolume) {
        this.multiVolume = multiVolume;
    }

    @Override
    public void backupStart(String tempDirectoryPath, String archiveFilenameBase) {
        this.archiver = new ZipArchiver();
        this.archives = Sets.newHashSet();
        this.archivesNumber = 1;
        this.currentArchiveFilesCount = 0;
        this.currentArchiveTotalFilesSize = 0L;
        this.tempDirectory = new File(tempDirectoryPath);
        this.archiveFilePathBase = archiveFilenameBase;
        Object currentArchiveFilePath = this.archiveFilePathBase + "_" + this.archivesNumber;
        currentArchiveFilePath = Util.createFileName((String)currentArchiveFilePath, this.getDescriptor().getArchiveFileExtension());
        this.archiver.setDestFile(new File(this.tempDirectory, (String)currentArchiveFilePath));
        if (this.multiVolume && (this.volumeSize <= 0L || this.volumeSize > 3999999999L)) {
            LOGGER.warning("Volume size " + this.volumeSize + " bytes is incorrect, setting to single volume.");
            this.multiVolume = false;
        }
    }

    @Override
    public void backupAddFile(File fileToStore) throws PeriodicBackupException {
        if (fileToStore.length() > 3999999999L) {
            throw new PeriodicBackupException("Size of file " + fileToStore.getAbsolutePath() + " is bigger then maximum allowed size (3906249kB). Cannot create archive.");
        }
        if (this.currentArchiveFilesCount + 1 >= 65534 || this.currentArchiveTotalFilesSize + fileToStore.length() >= 3999999999L) {
            LOGGER.info("Number of files in archive " + this.archiver.getDestFile().getAbsolutePath() + " exceeded 65534 or total size of files for this archive exceeded 3906249 kB");
            this.createNewArchive();
        } else if (this.multiVolume && fileToStore.length() >= this.volumeSize && this.currentArchiveFilesCount == 0) {
            this.addFile(fileToStore);
            LOGGER.info("Total size of files for this archive exceeded single volume size " + this.volumeSize + " B");
            this.createNewArchive();
        } else if (this.multiVolume && fileToStore.length() >= this.volumeSize && this.currentArchiveFilesCount > 0) {
            LOGGER.info("Total size of files for this archive exceeded single volume size " + this.volumeSize + " B");
            this.createNewArchive();
            this.addFile(fileToStore);
            LOGGER.info("Total size of files for this archive exceeded single volume size " + this.volumeSize + " B");
            this.createNewArchive();
        } else if (this.multiVolume && fileToStore.length() < this.volumeSize && this.currentArchiveTotalFilesSize + fileToStore.length() >= this.volumeSize) {
            LOGGER.info("Total size of files for this archive exceeded single volume size " + this.volumeSize + " B");
            this.createNewArchive();
            this.addFile(fileToStore);
        } else {
            this.addFile(fileToStore);
        }
    }

    private void createNewArchive() {
        try {
            this.archiver.createArchive();
        }
        catch (IOException e) {
            LOGGER.warning("Could not create archive " + String.valueOf(this.archiver.getDestFile()) + " " + e.getMessage());
        }
        catch (ArchiverException e) {
            LOGGER.warning("Could not create archive " + String.valueOf(this.archiver.getDestFile()) + " " + e.getMessage());
        }
        this.archives.add(this.archiver.getDestFile());
        ++this.archivesNumber;
        this.currentArchiveFilesCount = 0;
        this.currentArchiveTotalFilesSize = 0L;
        LOGGER.info("Creating new archive");
        this.archiver = new ZipArchiver();
        Object currentArchiveFilePath = this.archiveFilePathBase + "_" + this.archivesNumber;
        currentArchiveFilePath = Util.createFileName((String)currentArchiveFilePath, this.getDescriptor().getArchiveFileExtension());
        this.archiver.setDestFile(new File(this.tempDirectory, (String)currentArchiveFilePath));
    }

    private void addFile(File fileToStore) {
        try {
            this.archiver.addFile(fileToStore, Util.getRelativePath(fileToStore, Jenkins.getActiveInstance().getRootDir()));
            ++this.currentArchiveFilesCount;
            this.currentArchiveTotalFilesSize += fileToStore.length();
        }
        catch (ArchiverException e) {
            LOGGER.warning("Could not add file to the archive. " + e.getMessage());
        }
    }

    @Override
    public Iterable<File> backupStop() throws PeriodicBackupException {
        if (!this.archiver.getFiles().isEmpty()) {
            try {
                this.archiver.createArchive();
            }
            catch (Exception e) {
                throw new PeriodicBackupException("Could not create archive " + this.archiver.getDestFile().getAbsolutePath() + " " + e.getMessage());
            }
            this.archives.add(this.archiver.getDestFile());
        }
        return this.archives;
    }

    @Override
    public void unarchiveFiles(Iterable<File> archives, File tempDir) {
        ZipUnArchiver unarchiver = new ZipUnArchiver();
        unarchiver.setDestDirectory(tempDir);
        for (File archive : archives) {
            unarchiver.setSourceFile(archive);
            LOGGER.info("Extracting files from " + archive.getAbsolutePath() + " to " + tempDir.getAbsolutePath());
            try {
                unarchiver.extract();
            }
            catch (ArchiverException e) {
                LOGGER.warning("Could not extract from " + archive.getAbsolutePath() + e.getMessage());
            }
            LOGGER.info("Deleting " + archive.getAbsolutePath());
            if (archive.delete()) continue;
            LOGGER.warning("Could not delete " + archive.getAbsolutePath());
        }
    }

    public String getDisplayName() {
        return "Zip";
    }

    public boolean equals(Object o) {
        return o instanceof ZipStorage;
    }

    public int hashCode() {
        return 93;
    }

    @Extension
    public static class DescriptorImpl
    extends StorageDescriptor {
        public String getDisplayName() {
            return "ZipStorage";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Storage newInstance(StaplerRequest req, JSONObject formData) {
            long size = 3999999999L;
            try {
                size = Long.parseLong(req.getParameter("volumeSize"));
                return size;
            }
            finally {
                return new ZipStorage("on".equals(req.getParameter("multiVolume")), size);
            }
        }

        @Override
        public String getArchiveFileExtension() {
            return "zip";
        }
    }
}

