/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class Util {
    public static String getRelativePath(File file, File baseDir) {
        return baseDir.toURI().relativize(file.toURI()).getPath();
    }

    public static String generateFileNameBase(Date date) {
        return "backup_" + Util.getFormattedDate("yyyy_MM_dd_HH_mm_ss_SSS", date);
    }

    public static String getFormattedDate(String pattern, Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern);
        return dateFormat.format(date);
    }

    public static String createFileName(String fileName, String extension) {
        return fileName + "." + extension;
    }

    public static File createBackupObjectFile(BackupObject backupObject, String destinationDir, String fileNameBase) throws IOException {
        File backupObjectFile = new File(destinationDir, Util.createFileName(fileNameBase, "pbobj"));
        String xml = backupObject.getAsString();
        Files.write((CharSequence)xml, (File)backupObjectFile, (Charset)Charsets.UTF_8);
        return backupObjectFile;
    }

    public static boolean isValidBackupObjectFile(File backupObjectFile) throws IOException {
        if (!backupObjectFile.exists() || backupObjectFile.getUsableSpace() <= 0L) {
            return false;
        }
        String fileAsString = Files.toString((File)backupObjectFile, (Charset)Charsets.UTF_8);
        return fileAsString.contains("fileManager class=\"org.jenkinsci.plugins.periodicbackup") && fileAsString.contains("storage class=\"org.jenkinsci.plugins.periodicbackup") && fileAsString.contains("location class=\"org.jenkinsci.plugins.periodicbackup");
    }

    public static FileFilter extensionFileFilter(final String extension) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileExtension = Util.getExtension(file);
                return fileExtension != null && fileExtension.equals(extension);
            }
        };
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i == -1) {
            return null;
        }
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isWritableDirectory(File directory) {
        return directory.exists() && directory.isDirectory() && directory.canWrite();
    }

    public static File[] listFiles(@Nonnull File directory) throws PeriodicBackupException {
        return Util.listFiles(directory, null);
    }

    @Nonnull
    @Restricted(value={NoExternalUse.class})
    public static File[] listFiles(@Nonnull File directory, @CheckForNull FileFilter fileFilter) throws PeriodicBackupException {
        File[] files;
        if (!directory.exists()) {
            return new File[0];
        }
        if (!directory.isDirectory()) {
            throw new PeriodicBackupException(Util.formatMessage(directory, "File is not a directory"));
        }
        try {
            files = fileFilter == null ? directory.listFiles() : directory.listFiles(fileFilter);
        }
        catch (SecurityException ex) {
            throw new PeriodicBackupException(Util.formatMessage(directory, "Security exception while listing files"), ex);
        }
        if (files == null) {
            throw new PeriodicBackupException(Util.formatMessage(directory, "It is not a valid directory or there is an I/O error"));
        }
        return files;
    }

    private static String formatMessage(@Nonnull File directory, @Nonnull String extra) {
        StringBuilder bldr = new StringBuilder("Cannot list files of ");
        bldr.append(directory.getAbsolutePath());
        bldr.append(". ");
        bldr.append(extra);
        return bldr.toString();
    }
}

