/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.periodicbackup.FileManager;
import org.jenkinsci.plugins.periodicbackup.Location;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class BackupObject
implements Comparable {
    private final FileManager fileManager;
    private final Storage storage;
    private final Location location;
    private final Date timestamp;
    public static final String EXTENSION = "pbobj";
    public static final String FILE_TIMESTAMP_PATTERN = "yyyy_MM_dd_HH_mm_ss_SSS";

    public BackupObject(FileManager fileManager, Storage storage, Location location, Date timestamp) {
        this.fileManager = fileManager;
        this.storage = storage;
        this.location = location;
        this.timestamp = timestamp != null ? (Date)timestamp.clone() : null;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public Storage getStorage() {
        return this.storage;
    }

    public Location getLocation() {
        return this.location;
    }

    public static Function<File, BackupObject> getFromFile() {
        return new Function<File, BackupObject>(){

            public BackupObject apply(File file) {
                if (file != null) {
                    try {
                        return (BackupObject)Jenkins.XSTREAM.fromXML(Files.toString((File)file, (Charset)Charset.defaultCharset()));
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
                return null;
            }
        };
    }

    public static Function<String, BackupObject> getFromString() {
        return new Function<String, BackupObject>(){

            public BackupObject apply(String content) {
                if (content != null) {
                    return (BackupObject)Jenkins.XSTREAM.fromXML(content);
                }
                return null;
            }
        };
    }

    public static Function<InputStream, BackupObject> getFromInputStream() {
        return new Function<InputStream, BackupObject>(){

            public BackupObject apply(InputStream content) {
                if (content != null) {
                    return (BackupObject)Jenkins.XSTREAM.fromXML(content);
                }
                return null;
            }
        };
    }

    @Restricted(value={NoExternalUse.class})
    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getDisplayName() {
        return this.fileManager.getDisplayName() + " created on " + this.timestamp.toString();
    }

    public String getAsString() {
        return Jenkins.XSTREAM.toXML((Object)this);
    }

    public boolean equals(Object o) {
        if (o instanceof BackupObject) {
            BackupObject that = (BackupObject)o;
            return Objects.equal((Object)((Object)this.fileManager), (Object)((Object)that.fileManager)) && Objects.equal((Object)((Object)this.location), (Object)((Object)that.location)) && Objects.equal((Object)((Object)this.storage), (Object)((Object)that.storage)) && Objects.equal((Object)this.timestamp, (Object)that.timestamp);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.fileManager, this.storage, this.location, this.timestamp});
    }

    public int compareTo(Object o) {
        BackupObject that = (BackupObject)o;
        return this.timestamp.compareTo(that.getTimestamp());
    }
}

