/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.periodicbackup.AmazonUtil;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.Location;
import org.jenkinsci.plugins.periodicbackup.LocationDescriptor;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class S3
extends Location {
    private String bucket;
    private String prefix;
    private String tmpDir;
    private String region;
    private String credentialsId;
    private static final Logger LOGGER = Logger.getLogger(S3.class.getName());

    @DataBoundConstructor
    public S3(String bucket, boolean enabled, String tmpDir, String region, String credentialsId) {
        super(enabled);
        this.bucket = bucket;
        this.setTmpDir(tmpDir);
        this.setRegion(region);
        this.setCredentialsId(credentialsId);
    }

    @Override
    public Iterable<BackupObject> getAvailableBackups() {
        AmazonS3 client = AmazonUtil.getAmazonS3Client(this.region, this.credentialsId);
        List<S3ObjectSummary> objectSummarys = this.getObjectSummaries(client);
        return objectSummarys.parallelStream().filter(objectSummary -> StringUtils.endsWith((String)objectSummary.getKey(), (String)"pbobj") && this.isMatchPrefix(objectSummary.getKey())).map(objectSummary -> {
            try {
                S3ObjectInputStream content = client.getObject(this.bucket, objectSummary.getKey()).getObjectContent();
                return (BackupObject)BackupObject.getFromInputStream().apply((Object)content);
            }
            catch (Exception e) {
                LOGGER.warning("Exception while getting available backups from S3: " + String.valueOf(e));
                return null;
            }
        }).filter(Objects::nonNull).sorted(Comparator.comparing(BackupObject::getTimestamp))::iterator;
    }

    private boolean isMatchPrefix(String key) {
        Path s3ParentFolder = Paths.get(key, new String[0]).getParent();
        if (s3ParentFolder == null) {
            return StringUtils.isEmpty((String)this.prefix);
        }
        if (StringUtils.isEmpty((String)this.prefix)) {
            return false;
        }
        return s3ParentFolder.startsWith(this.prefix);
    }

    @Override
    public void storeBackupInLocation(Iterable<File> archives, File backupObjectFile) throws IOException {
        if (this.enabled && this.isBucketExists()) {
            AmazonS3 client = AmazonUtil.getAmazonS3Client(this.region, this.credentialsId);
            for (File archive : archives) {
                String backupPath = Paths.get(this.prefix, archive.getName()).toString().replace("\\", "/");
                LOGGER.info(archive.getName() + " copying to s3 bucket " + this.bucket + " > " + backupPath);
                client.putObject(this.bucket, backupPath, archive);
                LOGGER.info(archive.getName() + " copied to s3 bucket " + this.bucket + " > " + backupPath);
            }
            File dir = new File(this.tmpDir);
            if (!dir.isDirectory() && !dir.mkdir()) {
                LOGGER.warning("Unable to make temp directory: " + this.tmpDir);
                throw new IOException();
            }
            String backupPath = Paths.get(this.prefix, backupObjectFile.getName()).toString().replace("\\", "/");
            LOGGER.info(backupObjectFile.getName() + " copying to s3 bucket " + this.bucket + " > " + backupPath);
            client.putObject(this.bucket, backupPath, backupObjectFile);
            LOGGER.info(backupObjectFile.getName() + " copied to " + this.bucket + " > " + backupPath);
        } else {
            LOGGER.warning("skipping location " + this.bucket + " since it is disabled or it does not exist.");
        }
    }

    @Override
    public Iterable<File> retrieveBackupFromLocation(BackupObject backup, File tempDir) throws IOException, PeriodicBackupException {
        AmazonS3 client = AmazonUtil.getAmazonS3Client(this.region, this.credentialsId);
        List<S3ObjectSummary> objectSummarys = this.getObjectSummaries(client);
        return objectSummarys.parallelStream().filter(objectSummary -> objectSummary.getKey().contains(Util.getFormattedDate("yyyy_MM_dd_HH_mm_ss_SSS", backup.getTimestamp())) && !objectSummary.getKey().endsWith("pbobj") && this.isMatchPrefix(objectSummary.getKey())).map(S3ObjectSummary::getKey).map(backupFilename -> {
            Path p = Paths.get(backupFilename, new String[0]).getFileName();
            if (p == null) {
                LOGGER.warning("Unable to get file name from: " + backupFilename);
                return null;
            }
            p = Paths.get(this.tmpDir, p.toString());
            File copiedFile = p.toFile();
            try {
                LOGGER.fine("Copying from: " + this.bucket + " > " + backupFilename + " to " + copiedFile.getAbsolutePath());
                IOUtils.copy((InputStream)client.getObject(this.bucket, backupFilename).getObjectContent(), (OutputStream)new FileOutputStream(copiedFile));
                return copiedFile;
            }
            catch (Exception e) {
                LOGGER.warning("Exception while retriving the backup file from S3: " + String.valueOf(e));
                return null;
            }
        }).filter(Objects::nonNull)::iterator;
    }

    private List<S3ObjectSummary> getObjectSummaries(AmazonS3 client) {
        ObjectListing objectListing = StringUtils.isEmpty((String)this.prefix) ? client.listObjects(this.bucket) : client.listObjects(this.bucket, this.prefix);
        return objectListing.getObjectSummaries();
    }

    @Override
    public void deleteBackupFiles(BackupObject backupObject) {
        LOGGER.info("Deleting backupObject...");
        String filenamePart = Util.generateFileNameBase(backupObject.getTimestamp());
        AmazonS3 client = AmazonUtil.getAmazonS3Client(this.region, this.credentialsId);
        List<S3ObjectSummary> objectSummarys = this.getObjectSummaries(client);
        for (S3ObjectSummary objectSummary : objectSummarys) {
            if (!StringUtils.contains((String)objectSummary.getKey(), (String)filenamePart)) continue;
            LOGGER.info("Deleting backupObject..." + objectSummary.getKey());
            client.deleteObject(this.bucket, objectSummary.getKey());
            LOGGER.info("Deleted backupObject..." + objectSummary.getKey());
        }
    }

    public String getDisplayName() {
        if (StringUtils.isEmpty((String)this.prefix)) {
            return "S3 bucket: " + this.bucket;
        }
        return "S3 bucket: " + this.bucket + " > " + this.prefix;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public void setTmpDir(String tmpDir) {
        this.tmpDir = tmpDir;
    }

    private boolean isBucketExists() {
        AmazonS3 client = AmazonUtil.getAmazonS3Client(this.region, this.credentialsId);
        return client.doesBucketExistV2(this.bucket);
    }

    public String getPrefix() {
        return this.prefix;
    }

    @DataBoundSetter
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public boolean equals(Object o) {
        if (o instanceof S3) {
            S3 that = (S3)((Object)o);
            return com.google.common.base.Objects.equal((Object)this.bucket, (Object)that.bucket) && com.google.common.base.Objects.equal((Object)this.enabled, (Object)that.enabled);
        }
        return false;
    }

    public int hashCode() {
        if (StringUtils.isEmpty((String)this.prefix)) {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.bucket, this.enabled});
        }
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.bucket, this.enabled, this.prefix});
    }

    @Extension
    public static class DescriptorImpl
    extends LocationDescriptor {
        public String getDisplayName() {
            return "Amazon S3";
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="1.4")
        public FormValidation doTestBucket(@QueryParameter String bucket, @QueryParameter String region, @QueryParameter String credentialsId) throws AccessDeniedException {
            Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                return FormValidation.ok((String)this.validatePath(bucket, region, credentialsId));
            }
            catch (FormValidation f) {
                return f;
            }
        }

        private String validatePath(String bucket, String region, String credentialsId) throws FormValidation {
            AmazonS3 client = AmazonUtil.getAmazonS3Client(region, credentialsId);
            if (!client.doesBucketExistV2(bucket)) {
                throw FormValidation.error((String)(bucket + " doesn't exist or I don't have access to it!"));
            }
            return "bucket \"" + bucket + "\" OK";
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel regions = new ListBoxModel();
            regions.add("Auto", "");
            for (Regions s : Regions.values()) {
                regions.add(s.getDescription(), s.getName());
            }
            return regions;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems() {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            ListBoxModel credentials = new ListBoxModel();
            credentials.add("IAM instance Profile/user AWS configuration", "");
            credentials.addAll((Collection)CredentialsProvider.listCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList(), (CredentialsMatcher)CredentialsMatchers.instanceOf(AmazonWebServicesCredentials.class)));
            return credentials;
        }
    }
}

