/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.collect.Lists;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.jenkinsci.plugins.periodicbackup.StorageDescriptor;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.stapler.DataBoundConstructor;

public class NullStorage
extends Storage {
    private transient File destinationDirectory;
    private static final Logger LOGGER = Logger.getLogger(NullStorage.class.getName());

    @DataBoundConstructor
    public NullStorage() {
    }

    @Override
    public void backupStart(String tempDirectoryPath, String archiveFilenameBase) throws PeriodicBackupException {
        File tempDir = new File(tempDirectoryPath);
        this.destinationDirectory = new File(tempDir, archiveFilenameBase + ".null");
        if (this.destinationDirectory.exists()) {
            LOGGER.info("Destination directory " + this.destinationDirectory.getAbsolutePath() + " exists. Deleting...");
            try {
                FileUtils.deleteDirectory((File)this.destinationDirectory);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete destination directory " + this.destinationDirectory.getAbsolutePath());
            }
        }
    }

    @Override
    public void backupAddFile(File fileToStore) throws PeriodicBackupException {
        try {
            FileUtils.copyFile((File)fileToStore, (File)new File(this.destinationDirectory, Util.getRelativePath(fileToStore, Jenkins.getActiveInstance().getRootDir())));
        }
        catch (IOException e) {
            LOGGER.warning("Could not copy " + fileToStore.getAbsolutePath() + " to " + String.valueOf(this.destinationDirectory));
        }
    }

    @Override
    public Iterable<File> backupStop() throws PeriodicBackupException {
        return Lists.newArrayList((Object[])new File[]{this.destinationDirectory});
    }

    @Override
    public void unarchiveFiles(Iterable<File> archives, File finalResultDir) {
        for (File archive : archives) {
            try {
                LOGGER.info("Copying " + archive.getAbsolutePath() + " to " + finalResultDir.getAbsolutePath());
                if (archive.isDirectory()) {
                    FileUtils.copyDirectory((File)archive, (File)finalResultDir);
                    continue;
                }
                FileUtils.copyFile((File)archive, (File)new File(finalResultDir, archive.getName()));
            }
            catch (IOException e) {
                LOGGER.warning("Error during copying " + archive.getAbsolutePath() + " to " + finalResultDir.getAbsolutePath());
            }
        }
    }

    public String getDisplayName() {
        return "NullStorage";
    }

    public boolean equals(Object o) {
        return o instanceof NullStorage;
    }

    public int hashCode() {
        return 101;
    }

    @Extension
    public static class DescriptorImpl
    extends StorageDescriptor {
        public String getDisplayName() {
            return "NullStorage";
        }

        @Override
        public String getArchiveFileExtension() {
            return "null";
        }
    }
}

