/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hudson.Extension;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.DirectoryScanner;
import org.jenkinsci.plugins.periodicbackup.FileManager;
import org.jenkinsci.plugins.periodicbackup.FileManagerDescriptor;
import org.jenkinsci.plugins.periodicbackup.ReplaceRestorePolicy;
import org.kohsuke.stapler.DataBoundConstructor;

public class FullBackup
extends FileManager {
    @CheckForNull
    private final String includesString;
    @CheckForNull
    private final String excludesString;
    private final File baseDir;
    private final boolean followSymbolicLinks;

    public FullBackup() {
        this(null, null, false);
    }

    @DataBoundConstructor
    public FullBackup(@CheckForNull String includesString, @CheckForNull String excludesString, boolean followSymbolicLinks) {
        this(includesString, excludesString, followSymbolicLinks, Jenkins.get().getRootDir());
    }

    FullBackup(@CheckForNull String includesString, @CheckForNull String excludesString, boolean followSymbolicLinks, @Nonnull File baseDir) {
        this.includesString = StringUtils.trimToNull((String)includesString);
        this.excludesString = StringUtils.trimToNull((String)excludesString);
        this.followSymbolicLinks = followSymbolicLinks;
        this.baseDir = baseDir;
        this.restorePolicy = new ReplaceRestorePolicy();
    }

    public String getDisplayName() {
        return "FullBackup";
    }

    @Override
    public Iterable<File> getFilesToBackup() {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setFollowSymlinks(this.followSymbolicLinks);
        directoryScanner.setBasedir(this.baseDir);
        directoryScanner.setIncludes((String[])Iterators.toArray(this.getIncludes(), String.class));
        directoryScanner.setExcludes((String[])Iterators.toArray(this.getExcludes(), String.class));
        directoryScanner.scan();
        ArrayList files = Lists.newArrayList();
        for (String s : directoryScanner.getIncludedFiles()) {
            files.add(new File(directoryScanner.getBasedir(), s));
        }
        return files;
    }

    private Iterator<String> getIncludes() {
        if (this.includesString == null) {
            ArrayList includes = Lists.newArrayList();
            includes.add("**");
            return includes.iterator();
        }
        return Splitter.on((char)';').trimResults().split((CharSequence)this.includesString).iterator();
    }

    private Iterator<String> getExcludes() {
        if (this.excludesString == null) {
            return Collections.emptyListIterator();
        }
        return Splitter.on((char)';').trimResults().split((CharSequence)this.excludesString).iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FullBackup) {
            FullBackup that = (FullBackup)((Object)o);
            return Objects.equal((Object)this.restorePolicy, (Object)that.restorePolicy);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 73;
    }

    @CheckForNull
    public String getIncludesString() {
        return this.includesString;
    }

    @CheckForNull
    public String getExcludesString() {
        return this.excludesString;
    }

    public boolean isFollowSymbolicLinks() {
        return this.followSymbolicLinks;
    }

    @Extension
    public static class DescriptorImpl
    extends FileManagerDescriptor {
        public String getDisplayName() {
            return "FullBackup";
        }
    }
}

