/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import hudson.Extension;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.jenkinsci.plugins.periodicbackup.FileManager;
import org.jenkinsci.plugins.periodicbackup.FileManagerDescriptor;
import org.jenkinsci.plugins.periodicbackup.OverwriteRestorePolicy;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConfigOnly
extends FileManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigOnly.class.getName());

    @DataBoundConstructor
    public ConfigOnly() {
        this.restorePolicy = new OverwriteRestorePolicy();
    }

    public String getDisplayName() {
        return "ConfigOnly";
    }

    @Override
    public Iterable<File> getFilesToBackup() throws PeriodicBackupException {
        File rootDir = Jenkins.getActiveInstance().getRootDir();
        ArrayList filesToBackup = Lists.newArrayList();
        this.addRootFiles(rootDir, filesToBackup);
        this.addJobFiles(rootDir, filesToBackup);
        this.addUserFiles(rootDir, filesToBackup);
        return filesToBackup;
    }

    private void addRootFiles(File rootDir, List<File> filesToBackup) throws PeriodicBackupException {
        File[] xmlsInRoot = Util.listFiles(rootDir, Util.extensionFileFilter("xml"));
        filesToBackup.addAll(Arrays.asList(xmlsInRoot));
    }

    private void addJobFiles(File rootDir, List<File> filesToBackup) throws PeriodicBackupException {
        File jobsDir = new File(rootDir, "jobs");
        if (jobsDir.exists() && jobsDir.isDirectory()) {
            File[] dirsInJobs;
            for (File job : dirsInJobs = Util.listFiles(jobsDir, (FileFilter)FileFilterUtils.directoryFileFilter())) {
                File jobConfig = new File(job, "config.xml");
                if (jobConfig.exists() && jobConfig.isFile()) {
                    filesToBackup.add(jobConfig);
                    File promotionDir = new File(job, "promotions");
                    if (!promotionDir.exists()) continue;
                    try {
                        File[] promotionDirs;
                        for (File dir : promotionDirs = Util.listFiles(promotionDir, (FileFilter)FileFilterUtils.directoryFileFilter())) {
                            File promotionConfig = new File(dir, "config.xml");
                            if (!promotionConfig.exists() || !promotionConfig.isFile()) continue;
                            filesToBackup.add(promotionConfig);
                        }
                        continue;
                    }
                    catch (PeriodicBackupException ex) {
                        LOGGER.log(Level.WARNING, "Skipping the promotions for Job directory " + promotionDir.getAbsolutePath(), ex);
                        continue;
                    }
                }
                LOGGER.warning(jobConfig.getAbsolutePath() + " does not exist or is not a file.");
            }
        }
    }

    private void addUserFiles(File rootDir, List<File> filesToBackup) throws PeriodicBackupException {
        File usersDir = new File(rootDir, "users");
        if (usersDir.exists() && usersDir.isDirectory()) {
            File[] dirsInUsers;
            for (File user : dirsInUsers = Util.listFiles(usersDir, (FileFilter)FileFilterUtils.directoryFileFilter())) {
                File userConfig = new File(user, "config.xml");
                if (userConfig.exists() && userConfig.isFile()) {
                    filesToBackup.add(userConfig);
                    continue;
                }
                LOGGER.warning(userConfig.getAbsolutePath() + " does not exist or is not a file.");
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof ConfigOnly) {
            ConfigOnly that = (ConfigOnly)((Object)o);
            return Objects.equal((Object)this.restorePolicy, (Object)that.restorePolicy);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 97;
    }

    @Extension
    public static class DescriptorImpl
    extends FileManagerDescriptor {
        public String getDisplayName() {
            return "ConfigOnly";
        }
    }
}

