// CHECKSTYLE:OFF

package org.jenkinsci.plugins.periodicbackup;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code displayName}: {@code Periodic Backup Manager}.
     * 
     * @return
     *     {@code Periodic Backup Manager}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Periodic Backup Manager}.
     * 
     * @return
     *     {@code Periodic Backup Manager}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code description}: {@code Periodically backup your Jenkins data
     * and save the day.}.
     * 
     * @return
     *     {@code Periodically backup your Jenkins data and save the day.}
     */
    public static String description() {
        return holder.format("description");
    }

    /**
     * Key {@code description}: {@code Periodically backup your Jenkins data
     * and save the day.}.
     * 
     * @return
     *     {@code Periodically backup your Jenkins data and save the day.}
     */
    public static Localizable _description() {
        return new Localizable(holder, "description");
    }

}
