/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.collect.Lists;
import hudson.Extension;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.tar.TarArchiver;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.tar.TarLongFileMode;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.jenkinsci.plugins.periodicbackup.StorageDescriptor;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.stapler.DataBoundConstructor;

public class TarGzStorage
extends Storage {
    private transient TarArchiver archiver;
    private static final Logger LOGGER = Logger.getLogger(TarGzStorage.class.getName());

    @DataBoundConstructor
    public TarGzStorage() {
    }

    @Override
    public void backupStart(String tempDirectoryPath, String archiveFilenameBase) throws PeriodicBackupException {
        this.archiver = new TarArchiver();
        File destination = new File(new File(tempDirectoryPath), Util.createFileName(archiveFilenameBase, this.getDescriptor().getArchiveFileExtension()));
        this.archiver.setDestFile(destination);
        this.archiver.setLongfile(TarLongFileMode.gnu);
        this.archiver.setCompression(TarArchiver.TarCompressionMethod.gzip);
    }

    @Override
    public void backupAddFile(File fileToStore) throws PeriodicBackupException {
        try {
            this.archiver.addFile(fileToStore, Util.getRelativePath(fileToStore, Jenkins.getActiveInstance().getRootDir()));
        }
        catch (ArchiverException e) {
            LOGGER.warning("Could not add file to the archive. " + e.getMessage());
        }
    }

    @Override
    public Iterable<File> backupStop() throws PeriodicBackupException {
        try {
            this.archiver.createArchive();
        }
        catch (ArchiverException e) {
            LOGGER.warning("Could not create archive " + String.valueOf(this.archiver.getDestFile()) + " " + e.getMessage());
        }
        catch (IOException e) {
            LOGGER.warning("Could not create archive " + String.valueOf(this.archiver.getDestFile()) + " " + e.getMessage());
        }
        return Lists.newArrayList((Object[])new File[]{this.archiver.getDestFile()});
    }

    @Override
    public void unarchiveFiles(Iterable<File> archives, File tempDir) {
        TarGZipUnArchiver unArchiver = new TarGZipUnArchiver();
        unArchiver.setDestDirectory(tempDir);
        for (File archive : archives) {
            unArchiver.setSourceFile(archive);
            LOGGER.info("Extracting files from " + archive.getAbsolutePath() + " to " + tempDir.getAbsolutePath());
            try {
                unArchiver.extract();
            }
            catch (ArchiverException e) {
                LOGGER.warning("Could not extract from " + archive.getAbsolutePath() + e.getMessage());
            }
            LOGGER.info("Deleting " + archive.getAbsolutePath());
            if (archive.delete()) continue;
            LOGGER.warning("Could not delete " + archive.getAbsolutePath());
        }
    }

    public String getDisplayName() {
        return "TarGz";
    }

    public boolean equals(Object o) {
        return o instanceof TarGzStorage;
    }

    public int hashCode() {
        return 89;
    }

    @Extension
    public static class DescriptorImpl
    extends StorageDescriptor {
        public String getDisplayName() {
            return "TarGzStorage";
        }

        @Override
        public String getArchiveFileExtension() {
            return "tar.gz";
        }
    }
}

