/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import hudson.Plugin;
import hudson.logging.LogRecorder;
import hudson.security.ACL;
import java.io.IOException;
import java.util.logging.Level;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;

public class PeriodicBackupPlugin
extends Plugin {
    private static final String[] DEBUG_LOGGER_NAMES = new String[]{"org.jenkinsci.plugins.periodicbackup"};

    public void start() {
        this.updateDebugLogger(Level.ALL, DEBUG_LOGGER_NAMES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDebugLogger(Level level, String ... debugLoggerNames) {
        if (debugLoggerNames == null) {
            return;
        }
        Authentication oldAuth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            for (String current : debugLoggerNames) {
                LogRecorder recorder = Jenkins.getActiveInstance().getLog().getLogRecorder(current);
                if (recorder == null) {
                    Jenkins.getActiveInstance().getLog().doNewLogRecorder(current);
                    recorder = Jenkins.getActiveInstance().getLog().getLogRecorder(current);
                    recorder.getLoggers().add(new LogRecorder.Target(current, level));
                    try {
                        recorder.save();
                    }
                    catch (IOException ex) {
                        System.err.println("An error occured while saving logger recorder!");
                    }
                    continue;
                }
                LogRecorder.Target target = null;
                if (current != null) {
                    for (LogRecorder.Target currTarg : recorder.getLoggers()) {
                        if (!currTarg.name.equals(current)) continue;
                        target = currTarg;
                        break;
                    }
                }
                if (target != null) continue;
                recorder.getLoggers().add(new LogRecorder.Target(current, level));
                try {
                    recorder.save();
                }
                catch (IOException ex) {
                    System.err.println("An error occured while saving logger recorder!");
                }
            }
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(oldAuth);
        }
    }
}

