/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import antlr.ANTLRException;
import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.TaskListener;
import hudson.scheduler.CronTab;
import java.io.IOException;
import java.util.logging.Logger;
import org.codehaus.plexus.archiver.ArchiverException;
import org.jenkinsci.plugins.periodicbackup.BackupExecutor;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupLink;

@Extension
public class PeriodicBackup
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(PeriodicBackup.class.getName());

    public PeriodicBackup() {
        super("PeriodicBackup");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(TaskListener taskListener) {
        block13: {
            PeriodicBackupLink link = PeriodicBackupLink.get();
            String cron = link.getCron();
            if (cron != null) {
                try {
                    CronTab cronTab = new CronTab(link.getCron());
                    long currentTime = System.currentTimeMillis();
                    if (cronTab.ceil(currentTime).getTimeInMillis() - currentTime != 0L && !link.isBackupNow()) break block13;
                    link.setBackupNow(false);
                    BackupExecutor executor = new BackupExecutor();
                    try {
                        executor.backup(link.getFileManagerPlugin(), link.getStorages(), link.getLocations(), link.getTempDirectory(), link.getCycleQuantity(), link.getCycleDays());
                    }
                    catch (PeriodicBackupException e) {
                        LOGGER.warning("Backup failure " + e.getMessage());
                    }
                    catch (IOException e) {
                        LOGGER.warning("Backup failure " + e.getMessage());
                    }
                    catch (ArchiverException e) {
                        LOGGER.warning("Backup failure " + e.getMessage());
                    }
                    finally {
                        link.setMessage("");
                    }
                }
                catch (ANTLRException e) {
                    LOGGER.warning("Could not parse given cron tab! " + e.getMessage());
                }
            } else {
                LOGGER.warning("Cron is not defined.");
            }
        }
    }

    public long getRecurrencePeriod() {
        return 60000L;
    }

    public static PeriodicBackup get() {
        return (PeriodicBackup)((Object)AsyncPeriodicWork.all().get(PeriodicBackup.class));
    }
}

