/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Objects;
import hudson.DescriptorExtensionList;
import hudson.model.AbstractModelObject;
import hudson.model.Describable;
import java.io.File;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.periodicbackup.FileManagerDescriptor;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.RestorePolicy;

public abstract class FileManager
extends AbstractModelObject
implements Describable<FileManager> {
    RestorePolicy restorePolicy;

    public abstract Iterable<File> getFilesToBackup() throws PeriodicBackupException;

    public void restoreFiles(File finalResultDir) throws IOException, PeriodicBackupException {
        this.restorePolicy.restore(finalResultDir);
    }

    public static DescriptorExtensionList<FileManager, FileManagerDescriptor> all() {
        return Jenkins.getActiveInstance().getDescriptorList(FileManager.class);
    }

    public FileManagerDescriptor getDescriptor() {
        return (FileManagerDescriptor)Jenkins.getActiveInstance().getDescriptor(((Object)((Object)this)).getClass());
    }

    public String getSearchUrl() {
        return "FileManager";
    }

    public boolean equals(Object o) {
        if (o instanceof FileManager) {
            FileManager that = (FileManager)((Object)o);
            return Objects.equal((Object)this.restorePolicy, (Object)that.restorePolicy);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.restorePolicy});
    }
}

