/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import hudson.security.ACL;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupLink;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupRestartListener;
import org.jenkinsci.plugins.periodicbackup.Util;

public class RestoreExecutor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(RestoreExecutor.class.getName());
    private final BackupObject backupObject;
    private final String tempDirectoryPath;

    public RestoreExecutor(BackupObject backupObject, String tempDirectoryPath) {
        this.backupObject = backupObject;
        this.tempDirectoryPath = tempDirectoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File[] finalResultDirFileList;
        PeriodicBackupRestartListener restartListener = PeriodicBackupRestartListener.get();
        restartListener.notReady();
        long start = System.currentTimeMillis();
        File tempDir = new File(this.tempDirectoryPath);
        if (!Util.isWritableDirectory(tempDir)) {
            LOGGER.warning("Restoration Failure! The temporary folder " + tempDir.getAbsolutePath() + " is not writable. ");
            PeriodicBackupLink.get().setMessage("");
            return;
        }
        File finalResultDir = new File(tempDir, "finalResult");
        try {
            finalResultDirFileList = Util.listFiles(finalResultDir);
        }
        catch (PeriodicBackupException ex) {
            LOGGER.log(Level.WARNING, "Restoration Failure! Cannot list contents of " + finalResultDir.getAbsolutePath(), ex);
            PeriodicBackupLink.get().setMessage("");
            return;
        }
        if (finalResultDir.exists() && finalResultDirFileList.length > 0) {
            LOGGER.warning("The final result directory " + finalResultDir.getAbsolutePath() + " is not empty, deleting...");
            try {
                FileUtils.deleteDirectory((File)finalResultDir);
            }
            catch (IOException e) {
                LOGGER.warning("Could not delete " + finalResultDir.getAbsolutePath() + " " + e.getMessage());
            }
        }
        if (!finalResultDir.exists()) {
            LOGGER.info(finalResultDir.getAbsolutePath() + " does not exist, making new directory");
            if (!finalResultDir.mkdir()) {
                LOGGER.warning("Restoration Failure! Could not create " + finalResultDir.getAbsolutePath());
                PeriodicBackupLink.get().setMessage("");
                return;
            }
        }
        Iterable<File> archives = null;
        try {
            archives = this.backupObject.getLocation().retrieveBackupFromLocation(this.backupObject, tempDir);
        }
        catch (Exception e) {
            LOGGER.warning("Could not retrieve backup from location. " + e.getMessage());
            e.printStackTrace();
        }
        this.backupObject.getStorage().unarchiveFiles(archives, finalResultDir);
        try {
            this.backupObject.getFileManager().restoreFiles(finalResultDir);
        }
        catch (Exception e) {
            LOGGER.warning("Could not restore files. " + e.getMessage());
        }
        LOGGER.info("Reloading configuration...");
        Authentication origAuth = SecurityContextHolder.getContext().getAuthentication();
        SecurityContextHolder.getContext().setAuthentication(ACL.SYSTEM);
        try {
            Jenkins.getActiveInstance().doReload();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error reloading config files from disk: {0}", e.getMessage());
        }
        finally {
            LOGGER.log(Level.INFO, "Restoration finished after {0} ms", System.currentTimeMillis() - start);
            SecurityContextHolder.getContext().setAuthentication(origAuth);
            PeriodicBackupLink.get().setMessage("");
            restartListener.ready();
        }
    }
}

