/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.RestorePolicy;
import org.jenkinsci.plugins.periodicbackup.Util;

public class ReplaceRestorePolicy
implements RestorePolicy {
    private static final Logger LOGGER = Logger.getLogger(ReplaceRestorePolicy.class.getName());
    private File hudsonRoot;
    private List<String> autoExclusionList;
    private transient int filesDeleted;
    private transient int filesReplaced;
    private transient int filesKept;

    @Override
    public void restore(File tempDir) throws IOException, PeriodicBackupException {
        this.hudsonRoot = Jenkins.getActiveInstance().getRootDir();
        if (this.hudsonRoot == null) {
            throw new PeriodicBackupException("HOME directory is unidentified.");
        }
        this.autoExclusionList = Lists.newArrayList();
        this.filesDeleted = 0;
        this.filesReplaced = 0;
        this.filesKept = 0;
        this.deleteAccessible(Util.listFiles(this.hudsonRoot));
        LOGGER.info(this.filesDeleted + " files have been deleted from " + this.hudsonRoot.getAbsolutePath());
        this.replaceAccessible(Util.listFiles(tempDir), tempDir);
        LOGGER.info("Replacing of files finished.\nAfter deleting " + this.filesDeleted + " files from " + this.hudsonRoot.getAbsolutePath() + "\n" + this.filesReplaced + " files have been restored from backup and " + this.filesKept + " files have been kept.");
    }

    private void deleteAccessible(@Nonnull File[] files) throws PeriodicBackupException {
        for (File file : files) {
            if (!file.isDirectory()) {
                String relativePath;
                if (!file.canWrite()) {
                    LOGGER.warning("Access denied to " + file.getAbsolutePath() + ", file will not be replaced");
                    relativePath = Util.getRelativePath(file, this.hudsonRoot);
                    this.autoExclusionList.add(relativePath);
                    continue;
                }
                if (!file.delete()) {
                    LOGGER.warning("Access denied to " + file.getAbsolutePath() + ", file will not be replaced");
                    relativePath = Util.getRelativePath(file, this.hudsonRoot);
                    this.autoExclusionList.add(relativePath);
                    continue;
                }
                ++this.filesDeleted;
                continue;
            }
            this.deleteAccessible(Util.listFiles(file));
        }
    }

    private void replaceAccessible(File[] files, File tempDir) throws IOException, PeriodicBackupException {
        for (File file : files) {
            if (!file.isDirectory()) {
                String relativePath = Util.getRelativePath(file, tempDir);
                if (this.autoExclusionList == null || this.autoExclusionList.size() == 0 || this.autoExclusionList.size() > 0 && !this.autoExclusionList.contains(relativePath)) {
                    LOGGER.info("Copying " + file.getAbsolutePath() + " to " + this.hudsonRoot.getAbsolutePath());
                    File destinationFile = new File(this.hudsonRoot, relativePath);
                    FileUtils.copyFile((File)file, (File)destinationFile);
                    ++this.filesReplaced;
                    continue;
                }
                if (!this.autoExclusionList.contains(relativePath)) continue;
                LOGGER.warning("File " + file.getAbsolutePath() + " is excluded from the restore process, original file will be kept");
                ++this.filesKept;
                continue;
            }
            this.replaceAccessible(Util.listFiles(file), tempDir);
        }
    }

    public boolean equals(Object o) {
        return o instanceof ReplaceRestorePolicy;
    }

    public int hashCode() {
        return 83;
    }
}

