/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import antlr.ANTLRException;
import com.google.common.collect.Maps;
import hudson.BulkChange;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.ManagementLink;
import hudson.model.Saveable;
import hudson.scheduler.CronTab;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.AccessDeniedException;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.FileManager;
import org.jenkinsci.plugins.periodicbackup.FileManagerDescriptor;
import org.jenkinsci.plugins.periodicbackup.Location;
import org.jenkinsci.plugins.periodicbackup.LocationDescriptor;
import org.jenkinsci.plugins.periodicbackup.Messages;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackup;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.RestoreExecutor;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.jenkinsci.plugins.periodicbackup.StorageDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
public class PeriodicBackupLink
extends ManagementLink
implements Describable<PeriodicBackupLink>,
Saveable {
    private FileManager fileManagerPlugin = null;
    private final DescribableList<Location, LocationDescriptor> locationPlugins = new DescribableList((Saveable)this);
    private final DescribableList<Storage, StorageDescriptor> storagePlugins = new DescribableList((Saveable)this);
    private transient String message;
    private boolean backupNow = false;
    private String tempDirectory;
    private String cron;
    private int cycleQuantity;
    private int cycleDays;

    public PeriodicBackupLink() throws IOException {
        this.load();
    }

    public String getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(String tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public String getCron() {
        return this.cron;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public boolean isBackupNow() {
        return this.backupNow;
    }

    public void setBackupNow(boolean backupNow) {
        this.backupNow = backupNow;
    }

    public int getCycleQuantity() {
        return this.cycleQuantity;
    }

    public void setCycleQuantity(int cycleQuantity) {
        this.cycleQuantity = cycleQuantity;
    }

    public int getCycleDays() {
        return this.cycleDays;
    }

    public void setCycleDays(int cycleDays) {
        this.cycleDays = cycleDays;
    }

    public String getDisplayName() {
        return Messages.displayName();
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.4")
    public void doBackup(StaplerRequest req, StaplerResponse rsp) throws Exception {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        this.backupNow = true;
        PeriodicBackup.get().doRun();
        this.message = "Creating backup...";
        rsp.sendRedirect(".");
    }

    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.4")
    public void doRestore(StaplerRequest req, StaplerResponse rsp, @QueryParameter(value="backupHash") int backupHash) throws IOException, PeriodicBackupException {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        HashMap backupObjectMap = Maps.newHashMap();
        for (Location location : this.locationPlugins) {
            if (location.getAvailableBackups() == null) continue;
            for (BackupObject backupObject : location.getAvailableBackups()) {
                backupObjectMap.put(backupObject.hashCode(), backupObject);
            }
        }
        if (!backupObjectMap.keySet().contains(backupHash)) {
            throw new PeriodicBackupException("The provided hash code was not found in the map");
        }
        RestoreExecutor restoreExecutor = new RestoreExecutor((BackupObject)backupObjectMap.get(backupHash), this.tempDirectory);
        Thread t = new Thread(restoreExecutor);
        t.start();
        this.message = "Restoring backup...";
        rsp.sendRedirect(".");
    }

    public String getUrlName() {
        return "periodicbackup";
    }

    public String getIconFileName() {
        return "/plugin/periodicbackup/images/periodicbackup.svg";
    }

    public String getDescription() {
        return Messages.description();
    }

    protected void load() throws IOException {
        XmlFile xml = this.getConfigXml();
        if (xml.exists()) {
            xml.unmarshal((Object)this);
        }
    }

    public void save() throws IOException {
        if (BulkChange.contains((Saveable)this)) {
            return;
        }
        this.getConfigXml().write((Object)this);
    }

    protected XmlFile getConfigXml() {
        return new XmlFile(Jenkins.XSTREAM, new File(Jenkins.getActiveInstance().getRootDir(), "periodicBackup.xml"));
    }

    public String getRootDirectory() {
        return Jenkins.getActiveInstance().getRootDir().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequirePOST
    @Restricted(value={NoExternalUse.class})
    @RestrictedSince(value="1.4")
    public void doConfigSubmit(StaplerRequest req, StaplerResponse rsp) throws ServletException, IOException, ClassNotFoundException {
        Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
        JSONObject form = req.getSubmittedForm();
        BulkChange bc = new BulkChange((Saveable)this);
        try {
            this.tempDirectory = form.getString("tempDirectory");
            JSONObject fileManagerDescribableJson = form.getJSONObject("fileManagerPlugin");
            this.fileManagerPlugin = (FileManager)((Object)req.bindJSON(Class.forName(fileManagerDescribableJson.getString("stapler-class")), fileManagerDescribableJson));
            this.cron = form.getString("cron");
            this.cycleQuantity = form.getInt("cycleQuantity");
            this.cycleDays = form.getInt("cycleDays");
            this.locationPlugins.rebuildHetero(req, form, this.getLocationDescriptors(), "Location");
            this.storagePlugins.rebuildHetero(req, form, this.getStorageDescriptors(), "Storage");
        }
        catch (Descriptor.FormException e) {
            e.printStackTrace();
        }
        finally {
            bc.commit();
        }
        rsp.sendRedirect(".");
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.getActiveInstance().getDescriptorByType(DescriptorImpl.class);
    }

    public Collection<FileManagerDescriptor> getFileManagerDescriptors() {
        return FileManager.all();
    }

    public Collection<StorageDescriptor> getStorageDescriptors() {
        return Storage.all();
    }

    public Collection<LocationDescriptor> getLocationDescriptors() {
        return Location.all();
    }

    public FileManager getFileManagerPlugin() {
        return this.fileManagerPlugin;
    }

    public void setFileManagerPlugin(FileManager fileManagerPlugin) {
        this.fileManagerPlugin = fileManagerPlugin;
    }

    public DescribableList<Storage, StorageDescriptor> getStorages() {
        return this.storagePlugins;
    }

    public DescribableList<Location, LocationDescriptor> getLocations() {
        return this.locationPlugins;
    }

    public static PeriodicBackupLink get() {
        return (PeriodicBackupLink)((Object)ManagementLink.all().get(PeriodicBackupLink.class));
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<PeriodicBackupLink> {
        public String getDisplayName() {
            return "";
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="1.4")
        public FormValidation doTestCron(@QueryParameter String cron) throws AccessDeniedException {
            Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                return FormValidation.ok((String)this.validateCron(cron));
            }
            catch (FormValidation f) {
                return f;
            }
        }

        private String validateCron(String cron) throws FormValidation {
            try {
                new CronTab(cron);
            }
            catch (ANTLRException e) {
                throw FormValidation.error((String)(cron + " is not a valid cron syntax! " + e.getMessage()));
            }
            return "This cron is OK";
        }
    }
}

