/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import hudson.Extension;
import hudson.RestrictedSince;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.AccessDeniedException;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.Location;
import org.jenkinsci.plugins.periodicbackup.LocationDescriptor;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Util;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class LocalDirectory
extends Location {
    private File path;
    private static final Logger LOGGER = Logger.getLogger(LocalDirectory.class.getName());

    @DataBoundConstructor
    public LocalDirectory(File path, boolean enabled) {
        super(enabled);
        this.path = path;
    }

    @Override
    public Iterable<BackupObject> getAvailableBackups() {
        Object[] files;
        if (!Util.isWritableDirectory(this.path)) {
            LOGGER.warning(this.path.getAbsolutePath() + " is not a existing/writable directory.");
            return Sets.newHashSet();
        }
        FileFilter extensionFileFilter = Util.extensionFileFilter("pbobj");
        try {
            files = Util.listFiles(this.path, extensionFileFilter);
        }
        catch (PeriodicBackupException ex) {
            LOGGER.log(Level.WARNING, "Cannot retrieve extension files from " + this.path.getAbsolutePath(), ex);
            return Sets.newHashSet();
        }
        if (files.length == 0) {
            return Sets.newHashSet();
        }
        ArrayList backupObjectFiles = Lists.newArrayList((Object[])files);
        Collections.sort(backupObjectFiles);
        return Iterables.transform((Iterable)backupObjectFiles, BackupObject.getFromFile());
    }

    @Override
    public void storeBackupInLocation(Iterable<File> archives, File backupObjectFile) throws IOException {
        if (this.enabled && this.path.exists()) {
            for (File archive : archives) {
                File destination = new File(this.path, archive.getName());
                if (archive.isDirectory()) {
                    FileUtils.copyDirectory((File)archive, (File)destination);
                } else {
                    Files.copy((File)archive, (File)destination);
                }
                LOGGER.info(archive.getName() + " copied to " + destination.getAbsolutePath());
            }
            File backupObjectFileDestination = new File(this.path, backupObjectFile.getName());
            Files.copy((File)backupObjectFile, (File)backupObjectFileDestination);
            LOGGER.info(backupObjectFile.getName() + " copied to " + backupObjectFileDestination.getAbsolutePath());
        } else {
            LOGGER.warning("skipping location " + String.valueOf(this.path) + " since it is disabled or it does not exist.");
        }
    }

    @Override
    public Iterable<File> retrieveBackupFromLocation(final BackupObject backup, File tempDir) throws IOException, PeriodicBackupException {
        File[] files = Util.listFiles(this.path, new FileFilter(){
            final /* synthetic */ LocalDirectory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().contains(Util.getFormattedDate("yyyy_MM_dd_HH_mm_ss_SSS", backup.getTimestamp())) && !pathname.getName().endsWith("pbobj");
            }
        });
        if (files.length <= 0) {
            throw new PeriodicBackupException("Backup archives do not exist in " + this.path.getAbsolutePath());
        }
        HashSet archivesInTemp = Sets.newHashSet();
        for (File file : files) {
            File copiedFile = new File(tempDir, file.getName());
            if (copiedFile.exists()) {
                LOGGER.warning(copiedFile.getAbsolutePath() + " already exists, deleting... ");
                if (copiedFile.isDirectory()) {
                    FileUtils.deleteDirectory((File)copiedFile);
                } else if (!copiedFile.delete()) {
                    throw new PeriodicBackupException("Could not delete " + copiedFile.getAbsolutePath());
                }
            }
            LOGGER.info("Copying " + file.getAbsolutePath() + " to " + copiedFile.getAbsolutePath());
            if (file.isDirectory()) {
                FileUtils.copyDirectory((File)file, (File)copiedFile);
            } else {
                FileUtils.copyFile((File)file, (File)copiedFile);
            }
            LOGGER.info("Archive " + file.getAbsolutePath() + " copied to " + copiedFile.getAbsolutePath());
            archivesInTemp.add(copiedFile);
        }
        return archivesInTemp;
    }

    @Override
    public void deleteBackupFiles(BackupObject backupObject) {
        File[] files;
        String filenamePart = Util.generateFileNameBase(backupObject.getTimestamp());
        try {
            files = Util.listFiles(this.path);
        }
        catch (PeriodicBackupException ex) {
            LOGGER.log(Level.WARNING, "Cannot enumerate the backup files", ex);
            return;
        }
        for (File file : files) {
            if (!file.getAbsolutePath().contains(filenamePart)) continue;
            if (file.isDirectory()) {
                LOGGER.info("Deleting old/redundant backup archive directory " + file.getAbsolutePath());
                try {
                    FileUtils.deleteDirectory((File)file);
                }
                catch (IOException e) {
                    LOGGER.warning("Could not delete the temporary archive directory. " + e.getMessage());
                }
                continue;
            }
            LOGGER.info("Deleting old/redundant backup file " + file.getAbsolutePath());
            if (file.delete()) continue;
            LOGGER.warning("Could not delete file " + file.getAbsolutePath());
        }
    }

    public String getDisplayName() {
        return "LocalDirectory: " + String.valueOf(this.path);
    }

    public File getPath() {
        return this.path;
    }

    public void setPath(File path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o instanceof LocalDirectory) {
            LocalDirectory that = (LocalDirectory)((Object)o);
            return Objects.equal((Object)this.path, (Object)that.path) && Objects.equal((Object)this.enabled, (Object)that.enabled);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path, this.enabled});
    }

    @Extension
    public static class DescriptorImpl
    extends LocationDescriptor {
        public String getDisplayName() {
            return "LocalDirectory";
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="1.4")
        public FormValidation doTestPath(@QueryParameter String path) throws AccessDeniedException {
            Jenkins.getActiveInstance().checkPermission(Jenkins.ADMINISTER);
            try {
                return FormValidation.ok((String)this.validatePath(path));
            }
            catch (FormValidation f) {
                return f;
            }
        }

        private String validatePath(String path) throws FormValidation {
            File fileFromString = new File(path);
            if (!Util.isWritableDirectory(fileFromString)) {
                throw FormValidation.error((String)(path + " doesn't exists or is not a writable directory"));
            }
            return "directory \"" + path + "\" OK";
        }
    }
}

