/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.periodicbackup;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import hudson.util.DescribableList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.codehaus.plexus.archiver.ArchiverException;
import org.jenkinsci.plugins.periodicbackup.BackupObject;
import org.jenkinsci.plugins.periodicbackup.FileManager;
import org.jenkinsci.plugins.periodicbackup.Location;
import org.jenkinsci.plugins.periodicbackup.LocationDescriptor;
import org.jenkinsci.plugins.periodicbackup.PeriodicBackupException;
import org.jenkinsci.plugins.periodicbackup.Storage;
import org.jenkinsci.plugins.periodicbackup.StorageDescriptor;
import org.jenkinsci.plugins.periodicbackup.Util;

public class BackupExecutor {
    private final Set<File> filesToBackup = Sets.newHashSet();
    private static final Logger LOGGER = Logger.getLogger(BackupExecutor.class.getName());

    public void backup(FileManager fileManager, DescribableList<Storage, StorageDescriptor> storages, DescribableList<Location, LocationDescriptor> locations, String tempDirectory, int cycleQuantity, int cycleDays) throws ArchiverException, PeriodicBackupException, IOException {
        long start = System.currentTimeMillis();
        for (File f : fileManager.getFilesToBackup()) {
            this.filesToBackup.add(f);
        }
        Calendar timeThreshold = Calendar.getInstance();
        timeThreshold.add(5, -1 * cycleDays);
        for (Storage storage : storages) {
            Date timestamp = new Date();
            String fileNameBase = Util.generateFileNameBase(timestamp);
            storage.backupStart(tempDirectory, fileNameBase);
            for (File fileToBackup : this.filesToBackup) {
                storage.backupAddFile(fileToBackup);
            }
            Iterable<File> archives = storage.backupStop();
            for (Location location : locations) {
                if (location.enabled) {
                    BackupObject backupObject = new BackupObject(fileManager, storage, location, timestamp);
                    File backupObjectFile = Util.createBackupObjectFile(backupObject, tempDirectory, fileNameBase);
                    location.storeBackupInLocation(archives, backupObjectFile);
                    LOGGER.info("Deleting the temporary file " + backupObjectFile.getAbsolutePath());
                    if (!backupObjectFile.delete()) {
                        LOGGER.warning("Could not delete " + backupObjectFile.getAbsolutePath());
                    }
                    if (location.getAvailableBackups() == null) continue;
                    ArrayList backupsInLocation = Lists.newArrayList(location.getAvailableBackups());
                    LOGGER.info("Checking for redundant and old backups in the location.");
                    int index1 = -1;
                    int index2 = -1;
                    if (backupsInLocation.size() > cycleQuantity) {
                        index1 = backupsInLocation.size() - cycleQuantity;
                    }
                    for (BackupObject backupObj : backupsInLocation) {
                        if (!backupObj.getTimestamp().before(timeThreshold.getTime())) continue;
                        ++index2;
                    }
                    if (index1 == -1 && index2 == -1) continue;
                    for (int index = 0; index < Math.max(index1, index2); ++index) {
                        location.deleteBackupFiles((BackupObject)backupsInLocation.get(index));
                    }
                    continue;
                }
                LOGGER.info(location.getDisplayName() + " is disabled, ignoring.");
            }
            for (File f : archives) {
                if (f.isDirectory()) {
                    LOGGER.info("Deleting temporary archive directory " + f.getAbsolutePath());
                    FileUtils.deleteDirectory((File)f);
                    continue;
                }
                LOGGER.info("Deleting temporary file " + f.getAbsolutePath());
                if (f.delete()) continue;
                LOGGER.warning("Could not delete " + f.getAbsolutePath());
            }
        }
        LOGGER.info("Backup finished successfully after " + (System.currentTimeMillis() - start) + " ms");
    }
}

