/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.plugins.parameterizedtrigger.ITransformProjectParametersAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ProjectSpecificParametersActionFactory {
    private final List<ITransformProjectParametersAction> transforms;

    public ProjectSpecificParametersActionFactory(ITransformProjectParametersAction ... transforms) {
        this.transforms = new ArrayList<ITransformProjectParametersAction>(Arrays.asList(transforms));
    }

    public final List<Action> getProjectSpecificBuildActions(List<Action> baseActions, Job<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction pa = ProjectSpecificParametersActionFactory.getParametersAction(baseActions);
        for (Action a : baseActions) {
            if (a instanceof ParametersAction) continue;
            actions.add(a);
        }
        for (ITransformProjectParametersAction transform : this.transforms) {
            pa = transform.transformParametersAction(pa, project);
        }
        actions.add((Action)pa);
        return actions;
    }

    private static ParametersAction getParametersAction(List<Action> actions) {
        for (Action a : actions) {
            if (!(a instanceof ParametersAction)) continue;
            return (ParametersAction)a;
        }
        return new ParametersAction(new ParameterValue[0]);
    }
}

