/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.matrix.AxisList;
import hudson.matrix.Combination;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.StringParameterValue;
import hudson.model.TaskListener;
import hudson.model.TextParameterValue;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.util.VirtualFile;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FileBuildParameters
extends AbstractBuildParameters {
    private final String propertiesFile;
    private final String encoding;
    private final boolean failTriggerOnMissing;
    private final boolean textParamValueOnNewLine;
    private final boolean useMatrixChild;
    private final String combinationFilter;
    private final boolean onlyExactRuns;

    @DataBoundConstructor
    public FileBuildParameters(String propertiesFile, String encoding, boolean failTriggerOnMissing, boolean useMatrixChild, String combinationFilter, boolean onlyExactRuns, boolean textParamValueOnNewLine) {
        this.propertiesFile = propertiesFile;
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
        this.failTriggerOnMissing = failTriggerOnMissing;
        this.useMatrixChild = useMatrixChild;
        if (this.useMatrixChild) {
            this.combinationFilter = combinationFilter;
            this.onlyExactRuns = onlyExactRuns;
        } else {
            this.combinationFilter = null;
            this.onlyExactRuns = false;
        }
        this.textParamValueOnNewLine = textParamValueOnNewLine;
    }

    public FileBuildParameters(String propertiesFile, String encoding, boolean failTriggerOnMissing, boolean useMatrixChild, String combinationFilter, boolean onlyExactRuns) {
        this(propertiesFile, encoding, failTriggerOnMissing, useMatrixChild, combinationFilter, onlyExactRuns, false);
    }

    public FileBuildParameters(String propertiesFile, String encoding, boolean failTriggerOnMissing) {
        this(propertiesFile, encoding, failTriggerOnMissing, false, null, false);
    }

    public FileBuildParameters(String propertiesFile, boolean failTriggerOnMissing) {
        this(propertiesFile, null, failTriggerOnMissing);
    }

    public FileBuildParameters(String propertiesFile) {
        this(propertiesFile, false);
    }

    @Override
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        EnvVars env = this.getEnvironment(build, listener);
        String resolvedPropertiesFile = env.expand(this.propertiesFile);
        String[] allFiles = Util.tokenize((String)resolvedPropertiesFile, (String)",");
        String[] trimmedFiles = new String[allFiles.length];
        for (int i = 0; i < allFiles.length; ++i) {
            trimmedFiles[i] = allFiles[i].trim();
        }
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        Collection<AbstractBuild<?, ?>> targetBuilds = this.getTargetBuilds(build);
        for (AbstractBuild<?, ?> targetBuild : targetBuilds) {
            values.addAll(this.extractAllValues(targetBuild, listener, trimmedFiles));
        }
        return values.size() == 0 ? null : new ParametersAction(values);
    }

    private List<ParameterValue> extractAllValues(AbstractBuild<?, ?> build, TaskListener listener, String[] allFiles) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<ParameterValue> values = new ArrayList<ParameterValue>();
        EnvVars env = this.getEnvironment(build, listener);
        for (String file : allFiles) {
            String s = null;
            VirtualFile artifact = build.getArtifactManager().root().child(file);
            if (artifact.isFile()) {
                s = ParameterizedTriggerUtils.readFileToString(artifact);
            }
            if (s == null) {
                FilePath workspace = build.getWorkspace();
                if (workspace == null) {
                    listener.getLogger().printf("[parameterized-trigger] Could not load workspace of build %s%n", build.getFullDisplayName());
                } else {
                    FilePath f = workspace.child(file);
                    if (f.exists()) {
                        s = ParameterizedTriggerUtils.readFileToString(f, this.getEncoding());
                    }
                }
            }
            if (s == null) {
                listener.getLogger().println("[parameterized-trigger] Properties file " + file + " did not exist.");
                if (!this.getFailTriggerOnMissing()) continue;
                listener.getLogger().println("Not triggering due to missing file - did you archive it as a build artifact ?");
                throw new AbstractBuildParameters.DontTriggerException();
            }
            s = env.expand(s);
            Properties p = ParameterizedTriggerUtils.loadProperties(s);
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                s = entry.getValue().toString();
                if (this.textParamValueOnNewLine && s.contains("\n")) {
                    values.add((ParameterValue)new TextParameterValue(entry.getKey().toString(), s));
                    continue;
                }
                values.add((ParameterValue)new StringParameterValue(entry.getKey().toString(), s));
            }
        }
        return values;
    }

    private Collection<? extends AbstractBuild<?, ?>> getTargetBuilds(AbstractBuild<?, ?> build) {
        if (build instanceof MatrixBuild && this.isUseMatrixChild()) {
            Stream buildsStream = this.isOnlyExactRuns() ? ((MatrixBuild)build).getExactRuns().stream() : ((MatrixBuild)build).getRuns().stream();
            return buildsStream.filter(run -> {
                if (run == null) {
                    return false;
                }
                if (this.combinationFilter == null || this.combinationFilter.isBlank()) {
                    return true;
                }
                Combination c = run.getParent().getCombination();
                AxisList axes = run.getParent().getParent().getAxes();
                return c.evalGroovyExpression(axes, this.getCombinationFilter());
            }).collect(Collectors.toList());
        }
        return Arrays.asList(build);
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean getFailTriggerOnMissing() {
        return this.failTriggerOnMissing;
    }

    public boolean getTextParamValueOnNewLine() {
        return this.textParamValueOnNewLine;
    }

    public boolean isUseMatrixChild() {
        return this.useMatrixChild;
    }

    public String getCombinationFilter() {
        return this.combinationFilter;
    }

    public boolean isOnlyExactRuns() {
        return this.onlyExactRuns;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Parameters from properties file";
        }

        public FormValidation doCheckEncoding(@QueryParameter String encoding) {
            if (encoding != null && !encoding.isBlank()) {
                try {
                    Charset.forName(encoding.trim());
                }
                catch (UnsupportedCharsetException e) {
                    return FormValidation.error((String)"Unsupported Encoding");
                }
                catch (IllegalCharsetNameException e) {
                    return FormValidation.error((String)"Bad Encoding Name");
                }
            }
            return FormValidation.ok();
        }

        public boolean isMatrixProject(Object it) {
            return it != null && it instanceof MatrixProject;
        }
    }
}

