/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
final class CollectionUtils {
    CollectionUtils() {
    }

    static <T> List<T> immutableList(Collection<T> collection1, Collection<T> collection2) {
        ArrayList<T> list = new ArrayList<T>(collection1.size() + collection2.size());
        list.addAll(collection1);
        list.addAll(collection2);
        return Collections.unmodifiableList(list);
    }

    static <T> List<T> immutableList(Collection<T> collection, T ... ts) {
        return CollectionUtils.immutableList(collection, Arrays.asList(ts));
    }
}

