/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.FileParameterValue;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.FileBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.Messages;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;

public class BinaryFileParameterFactory
extends AbstractBuildParameterFactory {
    private final String parameterName;
    private final String filePattern;
    private final FileBuildParameterFactory.NoFilesFoundEnum noFilesFoundAction;
    private static Method $setLocation;
    private static final Logger LOGGER;

    @DataBoundConstructor
    public BinaryFileParameterFactory(String parameterName, String filePattern, FileBuildParameterFactory.NoFilesFoundEnum noFilesFoundAction) {
        this.parameterName = parameterName;
        this.filePattern = filePattern;
        this.noFilesFoundAction = noFilesFoundAction;
    }

    public BinaryFileParameterFactory(String parameterName, String filePattern) {
        this(parameterName, filePattern, FileBuildParameterFactory.NoFilesFoundEnum.SKIP);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public FileBuildParameterFactory.NoFilesFoundEnum getNoFilesFoundAction() {
        return this.noFilesFoundAction;
    }

    @Override
    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<AbstractBuildParameters> result = new ArrayList<AbstractBuildParameters>();
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IOException("Failed to get workspace");
        }
        try {
            FilePath target = new FilePath(build.getRootDir()).child("parameter-files");
            int n = workspace.copyRecursiveTo(this.getFilePattern(), target);
            if (n == 0) {
                this.noFilesFoundAction.failCheck(listener);
            } else {
                for (final FilePath f : target.list(this.getFilePattern())) {
                    LOGGER.fine("Triggering build with " + f.getName());
                    result.add(new AbstractBuildParameters(this){
                        final /* synthetic */ BinaryFileParameterFactory this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
                            assert (f.getChannel() == null);
                            FileParameterValue fv = new FileParameterValue(this.this$0.parameterName, new File(f.getRemote()), f.getName());
                            if ($setLocation != null) {
                                try {
                                    $setLocation.invoke((Object)fv, this.this$0.parameterName);
                                }
                                catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                                    // empty catch block
                                }
                            }
                            return new ParametersAction(new ParameterValue[]{fv});
                        }
                    });
                }
            }
        }
        catch (IOException ex) {
            throw new IOException("Failed to compute binary file parameters from " + this.getFilePattern(), ex);
        }
        return result;
    }

    static {
        try {
            $setLocation = FileParameterValue.class.getDeclaredMethod("setLocation", String.class);
            $setLocation.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        LOGGER = Logger.getLogger(BinaryFileParameterFactory.class.getName());
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.BinaryFileParameterFactory_DisplayName();
        }
    }
}

