/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.Messages;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import hudson.plugins.parameterizedtrigger.PredefinedBuildParameters;
import hudson.util.FormValidation;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FileBuildParameterFactory
extends AbstractBuildParameterFactory {
    private final String filePattern;
    private final String encoding;
    private final NoFilesFoundEnum noFilesFoundAction;

    @DataBoundConstructor
    public FileBuildParameterFactory(String filePattern, String encoding, NoFilesFoundEnum noFilesFoundAction) {
        this.filePattern = filePattern;
        this.encoding = Util.fixEmptyAndTrim((String)encoding);
        this.noFilesFoundAction = noFilesFoundAction;
    }

    public FileBuildParameterFactory(String filePattern, NoFilesFoundEnum noFilesFoundAction) {
        this(filePattern, null, noFilesFoundAction);
    }

    public FileBuildParameterFactory(String filePattern) {
        this(filePattern, NoFilesFoundEnum.SKIP);
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public NoFilesFoundEnum getNoFilesFoundAction() {
        return this.noFilesFoundAction;
    }

    @Override
    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        EnvVars env = build.getEnvironment(listener);
        ArrayList<AbstractBuildParameters> result = new ArrayList<AbstractBuildParameters>();
        try {
            FilePath workspace = this.getWorkspace(build);
            FilePath[] files = workspace.list(env.expand(this.getFilePattern()));
            if (files.length == 0) {
                this.noFilesFoundAction.failCheck(listener);
            } else {
                for (FilePath f : files) {
                    String parametersStr = ParameterizedTriggerUtils.readFileToString(f, this.getEncoding());
                    Logger.getLogger(FileBuildParameterFactory.class.getName()).log(Level.INFO, null, "Triggering build with " + f.getName());
                    result.add(new PredefinedBuildParameters(parametersStr));
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FileBuildParameterFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }

    private FilePath getWorkspace(AbstractBuild build) {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            workspace = build.getProject().getSomeWorkspace();
        }
        return workspace;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum NoFilesFoundEnum {
        SKIP("Don't trigger these projects"){

            @Override
            public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
                listener.getLogger().println(Messages.FileBuildParameterFactory_NoFilesFoundSkipping());
                throw new AbstractBuildParameters.DontTriggerException();
            }
        }
        ,
        NOPARMS("Skip these parameters"){

            @Override
            public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
                listener.getLogger().println(Messages.FileBuildParameterFactory_NoFilesFoundIgnore());
            }
        }
        ,
        FAIL("Fail the build step"){

            @Override
            public void failCheck(TaskListener listener) throws AbstractBuildParameters.DontTriggerException {
                listener.getLogger().println(Messages.FileBuildParameterFactory_NoFilesFoundTerminate());
                throw new RuntimeException();
            }
        };

        private final String description;

        public String getDescription() {
            return this.description;
        }

        private NoFilesFoundEnum(String description) {
            this.description = description;
        }

        public abstract void failCheck(TaskListener var1) throws AbstractBuildParameters.DontTriggerException;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return Messages.FileBuildParameterFactory_FileBuildParameterFactory();
        }

        public FormValidation doCheckEncoding(@QueryParameter String encoding) {
            if (encoding != null && !encoding.isBlank()) {
                try {
                    Charset.forName(encoding.trim());
                }
                catch (UnsupportedCharsetException e) {
                    return FormValidation.error((String)"Unsupported Encoding");
                }
                catch (IllegalCharsetNameException e) {
                    return FormValidation.error((String)"Bad Encoding Name");
                }
            }
            return FormValidation.ok();
        }
    }
}

