/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.model.queue.Tasks;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BuildInfoExporterAction;
import hudson.plugins.parameterizedtrigger.CollectionUtils;
import hudson.plugins.parameterizedtrigger.DefaultParameterValuesActionsTransform;
import hudson.plugins.parameterizedtrigger.Messages;
import hudson.plugins.parameterizedtrigger.ParameterizedTriggerUtils;
import hudson.plugins.parameterizedtrigger.ProjectSpecificParameterValuesActionTransform;
import hudson.plugins.parameterizedtrigger.ProjectSpecificParametersActionFactory;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.plugins.parameterizedtrigger.SubProjectData;
import hudson.plugins.promoted_builds.Promotion;
import hudson.security.ACL;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.security.QueueItemAuthenticatorConfiguration;
import org.acegisecurity.Authentication;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildTriggerConfig
implements Describable<BuildTriggerConfig> {
    private static final Logger LOGGER = Logger.getLogger(BuildTriggerConfig.class.getName());
    private final List<AbstractBuildParameters> configs;
    private final List<AbstractBuildParameterFactory> configFactories;
    private String projects;
    private final ResultCondition condition;
    private final boolean triggerWithNoParameters;
    private final boolean triggerFromChildProjects;

    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs, boolean triggerFromChildProjects) {
        this.projects = projects;
        this.condition = condition;
        this.triggerWithNoParameters = triggerWithNoParameters;
        this.configFactories = configFactories;
        this.configs = Util.fixNull(configs);
        this.triggerFromChildProjects = triggerFromChildProjects;
    }

    @Deprecated
    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameterFactory> configFactories, List<AbstractBuildParameters> configs) {
        this(projects, condition, triggerWithNoParameters, configFactories, configs, false);
    }

    @DataBoundConstructor
    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameters> configs, boolean triggerFromChildProjects) {
        this(projects, condition, triggerWithNoParameters, null, configs, triggerFromChildProjects);
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, boolean triggerWithNoParameters, List<AbstractBuildParameters> configs) {
        this(projects, condition, triggerWithNoParameters, null, configs, false);
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, AbstractBuildParameters ... configs) {
        this(projects, condition, false, null, Arrays.asList(configs), false);
    }

    public BuildTriggerConfig(String projects, ResultCondition condition, List<AbstractBuildParameterFactory> configFactories, AbstractBuildParameters ... configs) {
        this(projects, condition, false, configFactories, Arrays.asList(configs), false);
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    public List<AbstractBuildParameterFactory> getConfigFactories() {
        return this.configFactories;
    }

    public String getProjects() {
        return this.projects;
    }

    public String getProjects(EnvVars env) {
        return env != null ? env.expand(this.projects) : this.projects;
    }

    public ResultCondition getCondition() {
        return this.condition;
    }

    public boolean getTriggerWithNoParameters() {
        return this.triggerWithNoParameters;
    }

    public boolean isTriggerFromChildProjects() {
        return this.triggerFromChildProjects;
    }

    @Deprecated
    public List<AbstractProject> getProjectList(EnvVars env) {
        return this.getProjectList(null, env);
    }

    @Deprecated
    public List<AbstractProject> getProjectList(ItemGroup context, EnvVars env) {
        return Util.filter(this.getJobs(context, env), AbstractProject.class);
    }

    public List<Job> getJobs(ItemGroup context, EnvVars env) {
        ArrayList<Job> projectList = new ArrayList<Job>();
        projectList.addAll(BuildTriggerConfig.readableItemsFromNameList(context, this.getProjects(env), Job.class));
        return projectList;
    }

    public SubProjectData getProjectInfo(AbstractProject context) {
        SubProjectData subProjectData = new SubProjectData();
        BuildTriggerConfig.iterateBuilds(context, this.projects, subProjectData);
        subProjectData.getTriggered().removeAll(subProjectData.getDynamic());
        subProjectData.getTriggered().removeAll(subProjectData.getFixed());
        return subProjectData;
    }

    private static void iterateBuilds(AbstractProject context, String projects, SubProjectData subProjectData) {
        StringTokenizer stringTokenizer = new StringTokenizer(projects, ",");
        while (stringTokenizer.hasMoreTokens()) {
            subProjectData.getUnresolved().add(stringTokenizer.nextToken().trim());
        }
        int BACK_TRACK = 5;
        if (!subProjectData.getUnresolved().isEmpty()) {
            AbstractBuild currentBuild = context.getLastBuild();
            if (currentBuild == null) {
                subProjectData.getFixed().addAll(BuildTriggerConfig.readableItemsFromNameList(context.getParent(), projects, Job.class));
                for (Job staticProject : subProjectData.getFixed()) {
                    subProjectData.getUnresolved().remove(staticProject.getFullName());
                }
                return;
            }
            BuildTriggerConfig.resolveProject(currentBuild, subProjectData);
            currentBuild = currentBuild.getPreviousBuild();
            for (int backTrackCount = 0; currentBuild != null && backTrackCount < 5; currentBuild = currentBuild.getPreviousBuild(), ++backTrackCount) {
                BuildTriggerConfig.resolveProject(currentBuild, subProjectData);
            }
            if (currentBuild != null && context.getLastSuccessfulBuild() != null) {
                BuildTriggerConfig.resolveProject((AbstractBuild)context.getLastSuccessfulBuild(), subProjectData);
            }
        }
    }

    private static <T extends Item> List<T> readableItemsFromNameList(ItemGroup context, @NonNull String list, @NonNull Class<T> type) {
        Jenkins hudson = Jenkins.get();
        ArrayList<Item> r = new ArrayList<Item>();
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            Item item;
            block3: {
                String fullName = tokens.nextToken().trim();
                item = null;
                try {
                    item = hudson.getItem(fullName, context, type);
                }
                catch (RuntimeException x) {
                    if (x.getClass().getSimpleName().startsWith("AccessDeniedException")) break block3;
                    throw x;
                }
            }
            if (item == null) continue;
            r.add(item);
        }
        return r;
    }

    private static void resolveProject(AbstractBuild build, SubProjectData subProjectData) {
        Iterator<String> unsolvedProjectIterator = subProjectData.getUnresolved().iterator();
        while (unsolvedProjectIterator.hasNext()) {
            Job resolvedProject;
            Set<Job> destinationSet;
            block7: {
                String unresolvedProjectName = unsolvedProjectIterator.next();
                destinationSet = subProjectData.getFixed();
                if (unresolvedProjectName.contains("$")) {
                    EnvVars env = null;
                    try {
                        env = build != null ? build.getEnvironment() : null;
                    }
                    catch (IOException | InterruptedException exception) {
                        // empty catch block
                    }
                    unresolvedProjectName = env != null ? env.expand(unresolvedProjectName) : unresolvedProjectName;
                    destinationSet = subProjectData.getDynamic();
                }
                if (build == null) continue;
                resolvedProject = null;
                try {
                    resolvedProject = (Job)Jenkins.get().getItem(unresolvedProjectName, build.getProject().getParent(), Job.class);
                }
                catch (RuntimeException x) {
                    if (x.getClass().getSimpleName().startsWith("AccessDeniedException")) break block7;
                    throw x;
                }
            }
            if (resolvedProject == null) continue;
            destinationSet.add(resolvedProject);
            unsolvedProjectIterator.remove();
        }
        if (build != null && build.getAction(BuildInfoExporterAction.class) != null) {
            String triggeredProjects = ((BuildInfoExporterAction)build.getAction(BuildInfoExporterAction.class)).getProjectListString(",");
            subProjectData.getTriggered().addAll(BuildTriggerConfig.readableItemsFromNameList(build.getParent().getParent(), triggeredProjects, AbstractProject.class));
        }
    }

    List<Action> getBaseActions(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        return this.getBaseActions(this.configs, build, listener);
    }

    List<Action> getBaseActions(Collection<AbstractBuildParameters> configs, AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList<Action> actions = new ArrayList<Action>();
        ParametersAction params = null;
        for (AbstractBuildParameters config : configs) {
            Action a = config.getAction(build, listener);
            if (a instanceof ParametersAction) {
                params = params == null ? (ParametersAction)a : ParameterizedTriggerUtils.mergeParameters(params, (ParametersAction)a);
                continue;
            }
            if (a == null) continue;
            actions.add(a);
        }
        if (params != null) {
            actions.add((Action)params);
        }
        return actions;
    }

    List<Action> getBuildActions(List<Action> baseActions, Job<?, ?> project) {
        ArrayList<Action> actions = new ArrayList<Action>(baseActions);
        ProjectSpecificParametersActionFactory transformer = new ProjectSpecificParametersActionFactory(new ProjectSpecificParameterValuesActionTransform(), new DefaultParameterValuesActionsTransform());
        return transformer.getProjectSpecificBuildActions(actions, project);
    }

    public List<QueueTaskFuture<AbstractBuild>> perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.condition.isMet(build.getResult())) {
                QueueTaskFuture future = null;
                ArrayList<QueueTaskFuture<AbstractBuild>> futures = new ArrayList<QueueTaskFuture<AbstractBuild>>();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<AbstractBuildParameters> buildParams = new ArrayList<AbstractBuildParameters>(this.configs);
                    buildParams.addAll(addConfigs);
                    buildParams = Collections.unmodifiableList(buildParams);
                    List<Action> actions = this.getBaseActions(buildParams, build, (TaskListener)listener);
                    for (Job project : this.getJobs(build.getRootBuild().getProject().getParent(), env)) {
                        List<Action> list;
                        future = this.schedule(build, project, list = this.getBuildActions(actions, project), (TaskListener)listener);
                        if (future != null) {
                            futures.add((QueueTaskFuture<AbstractBuild>)future);
                            continue;
                        }
                        this.reportSchedulingError((Run<?, ?>)build, (Job<?, ?>)project, listener);
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException dontTriggerException) {
            // empty catch block
        }
        return Collections.emptyList();
    }

    private void reportSchedulingError(@NonNull Run<?, ?> run, @NonNull Job<?, ?> jobToTrigger, @NonNull BuildListener listener) {
        listener.error("Skipping " + jobToTrigger.getFullName() + "...");
        if (LOGGER.isLoggable(Level.CONFIG)) {
            String message = String.format("Cannot schedule project %s. Job type is not parameterized, or there is no Job/Build permission for the current authentication %s. Skipping...", jobToTrigger, Jenkins.getAuthentication().getName());
            LOGGER.log(Level.CONFIG, String.format("%s: %s", run, message), new UnsupportedOperationException("Cannot schedule job " + jobToTrigger.getFullName()));
        }
    }

    @Deprecated
    public ListMultimap<AbstractProject, QueueTaskFuture<AbstractBuild>> perform2(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        ListMultimap<Job, QueueTaskFuture<AbstractBuild>> initialResult = this.perform3(build, launcher, listener);
        ArrayListMultimap output = ArrayListMultimap.create();
        for (Map.Entry entry : initialResult.entries()) {
            if (!(entry.getKey() instanceof AbstractProject)) continue;
            output.put((Object)((AbstractProject)entry.getKey()), (Object)((QueueTaskFuture)entry.getValue()));
        }
        return output;
    }

    public ListMultimap<Job, QueueTaskFuture<AbstractBuild>> perform3(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        try {
            if (this.getCondition().isMet(build.getResult())) {
                ArrayListMultimap futures = ArrayListMultimap.create();
                for (List<AbstractBuildParameters> addConfigs : this.getDynamicBuildParameters(build, listener)) {
                    List<Action> actions = this.getBaseActions(CollectionUtils.immutableList(this.configs, addConfigs), build, (TaskListener)listener);
                    for (Job project : this.getJobs(build.getRootBuild().getProject().getParent(), env)) {
                        List<Action> list;
                        QueueTaskFuture scheduled = this.schedule(build, project, list = this.getBuildActions(actions, project), (TaskListener)listener);
                        if (scheduled != null) {
                            futures.put((Object)project, (Object)scheduled);
                            continue;
                        }
                        this.reportSchedulingError((Run<?, ?>)build, (Job<?, ?>)project, listener);
                    }
                }
                return futures;
            }
        }
        catch (AbstractBuildParameters.DontTriggerException dontTriggerException) {
            // empty catch block
        }
        return ArrayListMultimap.create();
    }

    private List<List<AbstractBuildParameters>> getDynamicBuildParameters(AbstractBuild<?, ?> build, BuildListener listener) throws AbstractBuildParameters.DontTriggerException, IOException, InterruptedException {
        if (this.configFactories == null || this.configFactories.isEmpty()) {
            return Collections.singletonList(Collections.emptyList());
        }
        ArrayList<List<AbstractBuildParameters>> dynamicBuildParameters = new ArrayList<List<AbstractBuildParameters>>();
        dynamicBuildParameters.add(Collections.emptyList());
        for (AbstractBuildParameterFactory configFactory : this.configFactories) {
            ArrayList<List<AbstractBuildParameters>> newDynParameters = new ArrayList<List<AbstractBuildParameters>>();
            List<AbstractBuildParameters> factoryParameters = configFactory.getParameters(build, (TaskListener)listener);
            if (factoryParameters.size() <= 0) continue;
            for (AbstractBuildParameters config : factoryParameters) {
                for (List list : dynamicBuildParameters) {
                    newDynParameters.add(CollectionUtils.immutableList(list, config));
                }
            }
            dynamicBuildParameters = newDynParameters;
        }
        return dynamicBuildParameters;
    }

    protected Cause createUpstreamCause(Run<?, ?> build) {
        if (Jenkins.getInstance().getPlugin("promoted-builds") != null && build instanceof Promotion) {
            Promotion promotion = (Promotion)build;
            return new Cause.UpstreamCause((Run)promotion.getTargetBuild());
        }
        return new Cause.UpstreamCause(build);
    }

    @Deprecated
    @CheckForNull
    protected QueueTaskFuture schedule(AbstractBuild<?, ?> build, Job project, int quietPeriod, List<Action> list) throws InterruptedException, IOException {
        return this.schedule(build, project, quietPeriod, list, TaskListener.NULL);
    }

    @CheckForNull
    protected QueueTaskFuture schedule(@NonNull AbstractBuild<?, ?> build, final @NonNull Job project, int quietPeriod, @NonNull List<Action> list, @NonNull TaskListener listener) throws InterruptedException, IOException {
        Cause cause = this.createUpstreamCause((Run<?, ?>)build);
        ArrayList<Action> queueActions = new ArrayList<Action>(list);
        queueActions.add((Action)new CauseAction(cause));
        if (project instanceof ParameterizedJobMixIn.ParameterizedJob) {
            ParameterizedJobMixIn parameterizedJobMixIn = new ParameterizedJobMixIn(){

                protected Job<?, ?> asJob() {
                    return project;
                }
            };
            if (!BuildTriggerConfig.canTriggerProject(build, project, listener)) {
                return null;
            }
            return parameterizedJobMixIn.scheduleBuild2(quietPeriod, queueActions.toArray(new Action[0]));
        }
        return null;
    }

    static boolean canTriggerProject(@NonNull AbstractBuild<?, ?> build, @NonNull Job job, @NonNull TaskListener taskListener) {
        if (!job.hasPermission(Item.BUILD)) {
            String message = String.format("Cannot schedule the build of %s from %s. The authenticated build user %s has no Job.BUILD permission", job.getFullDisplayName(), build.getFullDisplayName(), Jenkins.getAuthentication().getName());
            LOGGER.log(Level.WARNING, message);
            taskListener.error(message);
            return false;
        }
        return true;
    }

    protected boolean canBeScheduled(@NonNull Job<?, ?> job) {
        if (!job.isBuildable()) {
            return false;
        }
        return job.hasPermission(Item.BUILD);
    }

    @Deprecated
    protected QueueTaskFuture schedule(AbstractBuild<?, ?> build, Job project, List<Action> list) throws InterruptedException, IOException {
        return this.schedule(build, project, list, TaskListener.NULL);
    }

    @CheckForNull
    protected QueueTaskFuture schedule(@NonNull AbstractBuild<?, ?> build, @NonNull Job project, @NonNull List<Action> list, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (project instanceof ParameterizedJobMixIn.ParameterizedJob) {
            return this.schedule(build, project, ((ParameterizedJobMixIn.ParameterizedJob)project).getQuietPeriod(), list, listener);
        }
        return this.schedule(build, project, 0, list, listener);
    }

    private static String computeRelativeNamesAfterRenaming(String oldFullName, String newFullName, String relativeNames, ItemGroup<?> context) {
        StringTokenizer tokens = new StringTokenizer(relativeNames, ",");
        ArrayList<String> newValue = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String canonicalName = Items.getCanonicalName(context, (String)relativeName);
            if (canonicalName.equals(oldFullName) || canonicalName.startsWith(oldFullName + "/")) {
                String newCanonicalName = newFullName + canonicalName.substring(oldFullName.length());
                newValue.add(BuildTriggerConfig.computeRelativeNameAfterRenaming(canonicalName, newCanonicalName, relativeName));
                continue;
            }
            newValue.add(relativeName);
        }
        return String.join((CharSequence)",", newValue);
    }

    private static String computeRelativeNameAfterRenaming(String oldFullName, String newFullName, String relativeName) {
        String[] a = oldFullName.split("/");
        String[] n = newFullName.split("/");
        assert (a.length == n.length);
        CharSequence[] r = relativeName.split("/");
        int j = a.length - 1;
        for (int i = r.length - 1; i >= 0; --i) {
            String part = r[i];
            if (part.equals("") && i == 0 || part.equals(".")) continue;
            if (part.equals("..")) {
                --j;
                continue;
            }
            if (!part.equals(a[j])) continue;
            r[i] = n[j];
            --j;
        }
        return String.join((CharSequence)"/", r);
    }

    public boolean onJobRenamed(ItemGroup context, String oldName, String newName) {
        String newProjects = BuildTriggerConfig.computeRelativeNamesAfterRenaming(oldName, newName, this.projects, context);
        boolean changed = !this.projects.equals(newProjects);
        this.projects = newProjects;
        return changed;
    }

    public boolean onDeleted(ItemGroup context, String oldName) {
        ArrayList<String> newNames = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(this.projects, ",");
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String fullName = Items.getCanonicalName((ItemGroup)context, (String)relativeName);
            if (fullName.equals(oldName)) continue;
            newNames.add(relativeName);
        }
        String newProjects = String.join((CharSequence)",", newNames);
        boolean changed = !this.projects.equals(newProjects);
        this.projects = newProjects;
        return changed;
    }

    public Descriptor<BuildTriggerConfig> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(this.getClass());
    }

    public String toString() {
        return this.getClass().getName() + " [projects=" + this.projects + ", condition=" + String.valueOf((Object)this.condition) + ", configs=" + String.valueOf(this.configs) + "]";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BuildTriggerConfig> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        public List<Descriptor<AbstractBuildParameterFactory>> getBuilderConfigFactoryDescriptors() {
            return Jenkins.getInstance().getDescriptorList(AbstractBuildParameterFactory.class);
        }

        @Restricted(value={DoNotUse.class})
        public boolean isItemGroup(AbstractProject project) {
            return project instanceof ItemGroup;
        }

        public FormValidation doCheckProjects(@AncestorInPath Job<?, ?> project, @QueryParameter String value) {
            if (project == null) {
                return FormValidation.ok((String)"Context Unknown: the value specified cannot be validated");
            }
            if (!project.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            boolean hasProjects = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if (projectName.isBlank()) {
                    return FormValidation.error((String)"Blank project name in the list");
                }
                Item item = Jenkins.get().getItem(projectName, project, Item.class);
                if (item == null) {
                    Item nearest = Items.findNearest(Job.class, (String)projectName, (ItemGroup)Jenkins.get());
                    String alternative = nearest != null ? nearest.getRelativeNameFrom(project) : "?";
                    return FormValidation.error((String)Messages.BuildTrigger_NoSuchProject(projectName, alternative));
                }
                if (!(item instanceof Job) || !(item instanceof ParameterizedJobMixIn.ParameterizedJob)) {
                    return FormValidation.error((String)Messages.BuildTrigger_NotBuildable(projectName));
                }
                Authentication auth = Tasks.getAuthenticationOf((Queue.Task)((ParameterizedJobMixIn.ParameterizedJob)project));
                if (auth.equals((Object)ACL.SYSTEM) && !QueueItemAuthenticatorConfiguration.get().getAuthenticators().isEmpty()) {
                    auth = Jenkins.ANONYMOUS;
                }
                if (!item.getACL().hasPermission(auth, Item.BUILD)) {
                    return FormValidation.error((String)Messages.BuildTrigger_you_have_no_permission_to_build_(projectName));
                }
                hasProjects = true;
            }
            if (!hasProjects) {
                return FormValidation.error((String)Messages.BuildTrigger_NoProjectSpecified());
            }
            return FormValidation.ok();
        }

        public AutoCompletionCandidates doAutoCompleteProjects(@QueryParameter String value, @AncestorInPath ItemGroup context) {
            AutoCompletionCandidates candidates = new AutoCompletionCandidates();
            List jobs = Jenkins.get().getAllItems(Job.class);
            for (Job job : jobs) {
                String relativeName = job.getRelativeNameFrom(context);
                if (!relativeName.startsWith(value) || !job.hasPermission(Item.READ)) continue;
                candidates.add(relativeName);
            }
            return candidates;
        }
    }
}

