/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Result;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.stapler.DataBoundConstructor;

public class BlockingBehaviour
extends AbstractDescribableImpl<BlockingBehaviour> {
    public final Result buildStepFailureThreshold;
    public final Result unstableThreshold;
    public final Result failureThreshold;

    @DataBoundConstructor
    public BlockingBehaviour(String buildStepFailureThreshold, String unstableThreshold, String failureThreshold) {
        this.buildStepFailureThreshold = this.parse(buildStepFailureThreshold);
        this.unstableThreshold = this.parse(unstableThreshold);
        this.failureThreshold = this.parse(failureThreshold);
    }

    private Result parse(String t) {
        if (t == null || t.isBlank() || "never".equals(t)) {
            return null;
        }
        return Result.fromString((String)t);
    }

    public BlockingBehaviour(Result buildStepFailureThreshold, Result unstableThreshold, Result failureThreshold) {
        this.buildStepFailureThreshold = buildStepFailureThreshold;
        this.unstableThreshold = unstableThreshold;
        this.failureThreshold = failureThreshold;
    }

    public boolean mapBuildStepResult(Result r) {
        return this.buildStepFailureThreshold == null || !r.isWorseOrEqualTo(this.buildStepFailureThreshold);
    }

    @CheckForNull
    public Result mapBuildResult(Result r) {
        if (this.failureThreshold != null && r.isWorseOrEqualTo(this.failureThreshold)) {
            return Result.FAILURE;
        }
        if (this.unstableThreshold != null && r.isWorseOrEqualTo(this.unstableThreshold)) {
            return Result.UNSTABLE;
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<BlockingBehaviour> {
        public String getDisplayName() {
            return "";
        }

        public List<Result> getAllResults() {
            return Arrays.asList(Result.SUCCESS, Result.UNSTABLE, Result.FAILURE);
        }
    }
}

