// CHECKSTYLE:OFF

package hudson.plugins.parameterizedtrigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Hudson.NotANumber}: {@code Not a number}.
     * 
     * @return
     *     {@code Not a number}
     */
    public static String Hudson_NotANumber() {
        return holder.format("Hudson.NotANumber");
    }

    /**
     * Key {@code Hudson.NotANumber}: {@code Not a number}.
     * 
     * @return
     *     {@code Not a number}
     */
    public static Localizable _Hudson_NotANumber() {
        return new Localizable(holder, "Hudson.NotANumber");
    }

    /**
     * Key {@code BuildTrigger.NoProjectSpecified}: {@code No project

     * specified}.
     * 
     * @return
     *     {@code No project specified}
     */
    public static String BuildTrigger_NoProjectSpecified() {
        return holder.format("BuildTrigger.NoProjectSpecified");
    }

    /**
     * Key {@code BuildTrigger.NoProjectSpecified}: {@code No project

     * specified}.
     * 
     * @return
     *     {@code No project specified}
     */
    public static Localizable _BuildTrigger_NoProjectSpecified() {
        return new Localizable(holder, "BuildTrigger.NoProjectSpecified");
    }

    /**
     * Key {@code BuildTrigger.you_have_no_permission_to_build_}: {@code You

     * have no permission to build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have no permission to build {0}}
     */
    public static String BuildTrigger_you_have_no_permission_to_build_(Object arg0) {
        return holder.format("BuildTrigger.you_have_no_permission_to_build_", arg0);
    }

    /**
     * Key {@code BuildTrigger.you_have_no_permission_to_build_}: {@code You

     * have no permission to build {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have no permission to build {0}}
     */
    public static Localizable _BuildTrigger_you_have_no_permission_to_build_(Object arg0) {
        return new Localizable(holder, "BuildTrigger.you_have_no_permission_to_build_", arg0);
    }

    /**
     * Key {@code

     * CounterBuildParameterFactory.CountingWillNotTerminateSkipping}: {@code

     * To, from and step form a infinite set, counting will not terminate!

     * Triggering Skipped.}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate! Triggering Skipped.}
     */
    public static String CounterBuildParameterFactory_CountingWillNotTerminateSkipping() {
        return holder.format("CounterBuildParameterFactory.CountingWillNotTerminateSkipping");
    }

    /**
     * Key {@code

     * CounterBuildParameterFactory.CountingWillNotTerminateSkipping}: {@code

     * To, from and step form a infinite set, counting will not terminate!

     * Triggering Skipped.}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate! Triggering Skipped.}
     */
    public static Localizable _CounterBuildParameterFactory_CountingWillNotTerminateSkipping() {
        return new Localizable(holder, "CounterBuildParameterFactory.CountingWillNotTerminateSkipping");
    }

    /**
     * Key {@code FileBuildParameterFactory.FileBuildParameterFactory}:

     * {@code For every property file, invoke one build}.
     * 
     * @return
     *     {@code For every property file, invoke one build}
     */
    public static String FileBuildParameterFactory_FileBuildParameterFactory() {
        return holder.format("FileBuildParameterFactory.FileBuildParameterFactory");
    }

    /**
     * Key {@code FileBuildParameterFactory.FileBuildParameterFactory}:

     * {@code For every property file, invoke one build}.
     * 
     * @return
     *     {@code For every property file, invoke one build}
     */
    public static Localizable _FileBuildParameterFactory_FileBuildParameterFactory() {
        return new Localizable(holder, "FileBuildParameterFactory.FileBuildParameterFactory");
    }

    /**
     * Key {@code BinaryFileParameterFactory.DisplayName}: {@code For every

     * matching file, invoke one build}.
     * 
     * @return
     *     {@code For every matching file, invoke one build}
     */
    public static String BinaryFileParameterFactory_DisplayName() {
        return holder.format("BinaryFileParameterFactory.DisplayName");
    }

    /**
     * Key {@code BinaryFileParameterFactory.DisplayName}: {@code For every

     * matching file, invoke one build}.
     * 
     * @return
     *     {@code For every matching file, invoke one build}
     */
    public static Localizable _BinaryFileParameterFactory_DisplayName() {
        return new Localizable(holder, "BinaryFileParameterFactory.DisplayName");
    }

    /**
     * Key {@code

     * CounterBuildParameterFactory.CountingWillNotTerminateIgnore}: {@code

     * To, from and step form a infinite set, counting will not terminate!

     * Parameters Ignored.}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate! Parameters Ignored.}
     */
    public static String CounterBuildParameterFactory_CountingWillNotTerminateIgnore() {
        return holder.format("CounterBuildParameterFactory.CountingWillNotTerminateIgnore");
    }

    /**
     * Key {@code

     * CounterBuildParameterFactory.CountingWillNotTerminateIgnore}: {@code

     * To, from and step form a infinite set, counting will not terminate!

     * Parameters Ignored.}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate! Parameters Ignored.}
     */
    public static Localizable _CounterBuildParameterFactory_CountingWillNotTerminateIgnore() {
        return new Localizable(holder, "CounterBuildParameterFactory.CountingWillNotTerminateIgnore");
    }

    /**
     * Key {@code BuildTrigger.NotBuildable}: {@code {0} is not buildable}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not buildable}
     */
    public static String BuildTrigger_NotBuildable(Object arg0) {
        return holder.format("BuildTrigger.NotBuildable", arg0);
    }

    /**
     * Key {@code BuildTrigger.NotBuildable}: {@code {0} is not buildable}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code {0} is not buildable}
     */
    public static Localizable _BuildTrigger_NotBuildable(Object arg0) {
        return new Localizable(holder, "BuildTrigger.NotBuildable", arg0);
    }

    /**
     * Key {@code CounterBuildParameterFactory.CountingWillNotTerminate}:

     * {@code To, from and step form a infinite set, counting will not

     * terminate!}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate!}
     */
    public static String CounterBuildParameterFactory_CountingWillNotTerminate() {
        return holder.format("CounterBuildParameterFactory.CountingWillNotTerminate");
    }

    /**
     * Key {@code CounterBuildParameterFactory.CountingWillNotTerminate}:

     * {@code To, from and step form a infinite set, counting will not

     * terminate!}.
     * 
     * @return
     *     {@code To, from and step form a infinite set, counting will not

     *     terminate!}
     */
    public static Localizable _CounterBuildParameterFactory_CountingWillNotTerminate() {
        return new Localizable(holder, "CounterBuildParameterFactory.CountingWillNotTerminate");
    }

    /**
     * Key {@code CounterBuildParameterFactory.CounterBuildParameterFactory}:

     * {@code Invoke i=0...N builds}.
     * 
     * @return
     *     {@code Invoke i=0...N builds}
     */
    public static String CounterBuildParameterFactory_CounterBuildParameterFactory() {
        return holder.format("CounterBuildParameterFactory.CounterBuildParameterFactory");
    }

    /**
     * Key {@code CounterBuildParameterFactory.CounterBuildParameterFactory}:

     * {@code Invoke i=0...N builds}.
     * 
     * @return
     *     {@code Invoke i=0...N builds}
     */
    public static Localizable _CounterBuildParameterFactory_CounterBuildParameterFactory() {
        return new Localizable(holder, "CounterBuildParameterFactory.CounterBuildParameterFactory");
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundIgnore}: {@code No

     * Files Found! Parameters Ignored.}.
     * 
     * @return
     *     {@code No Files Found! Parameters Ignored.}
     */
    public static String FileBuildParameterFactory_NoFilesFoundIgnore() {
        return holder.format("FileBuildParameterFactory.NoFilesFoundIgnore");
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundIgnore}: {@code No

     * Files Found! Parameters Ignored.}.
     * 
     * @return
     *     {@code No Files Found! Parameters Ignored.}
     */
    public static Localizable _FileBuildParameterFactory_NoFilesFoundIgnore() {
        return new Localizable(holder, "FileBuildParameterFactory.NoFilesFoundIgnore");
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.

     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static String BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return holder.format("BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code BuildTrigger.NoSuchProject}: {@code No such project ‘{0}’.

     * Did you mean ‘{1}’?}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such project ‘{0}’. Did you mean ‘{1}’?}
     */
    public static Localizable _BuildTrigger_NoSuchProject(Object arg0, Object arg1) {
        return new Localizable(holder, "BuildTrigger.NoSuchProject", arg0, arg1);
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundTerminate}: {@code No

     * Files Found!}.
     * 
     * @return
     *     {@code No Files Found!}
     */
    public static String FileBuildParameterFactory_NoFilesFoundTerminate() {
        return holder.format("FileBuildParameterFactory.NoFilesFoundTerminate");
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundTerminate}: {@code No

     * Files Found!}.
     * 
     * @return
     *     {@code No Files Found!}
     */
    public static Localizable _FileBuildParameterFactory_NoFilesFoundTerminate() {
        return new Localizable(holder, "FileBuildParameterFactory.NoFilesFoundTerminate");
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundSkipping}: {@code No

     * Files Found! Triggering Skipped.}.
     * 
     * @return
     *     {@code No Files Found! Triggering Skipped.}
     */
    public static String FileBuildParameterFactory_NoFilesFoundSkipping() {
        return holder.format("FileBuildParameterFactory.NoFilesFoundSkipping");
    }

    /**
     * Key {@code FileBuildParameterFactory.NoFilesFoundSkipping}: {@code No

     * Files Found! Triggering Skipped.}.
     * 
     * @return
     *     {@code No Files Found! Triggering Skipped.}
     */
    public static Localizable _FileBuildParameterFactory_NoFilesFoundSkipping() {
        return new Localizable(holder, "FileBuildParameterFactory.NoFilesFoundSkipping");
    }

}
