/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ListMultimap;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.console.ModelHyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependencyGraph;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.User;
import hudson.model.queue.QueueTaskFuture;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BuildInfoExporterAction;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.plugins.parameterizedtrigger.SubProjectsAction;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import jenkins.model.DependencyDeclarer;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class TriggerBuilder
extends Builder
implements DependencyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(TriggerBuilder.class.getName());
    private final ArrayList<BlockableBuildTriggerConfig> configs;

    @DataBoundConstructor
    public TriggerBuilder(List<BlockableBuildTriggerConfig> configs) {
        this.configs = new ArrayList(Util.fixNull(configs));
    }

    public TriggerBuilder(BlockableBuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BlockableBuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        boolean buildStepResult = true;
        try {
            for (BlockableBuildTriggerConfig config : this.configs) {
                ListMultimap<Job, QueueTaskFuture<AbstractBuild>> futures = config.perform3(build, launcher, listener);
                List<Job> projectList = config.getJobs(build.getRootBuild().getProject().getParent(), env);
                StringTokenizer tokenizer = new StringTokenizer(config.getProjects(env), ",");
                if (tokenizer.countTokens() == 0) {
                    throw new AbortException("Build aborted. No projects to trigger. Check your configuration!");
                }
                if (tokenizer.countTokens() != projectList.size()) {
                    int nbrOfResolved = tokenizer.countTokens() - projectList.size();
                    TreeSet<String> unsolvedProjectNames = new TreeSet<String>();
                    while (tokenizer.hasMoreTokens()) {
                        unsolvedProjectNames.add(tokenizer.nextToken().trim());
                    }
                    for (Job job : projectList) {
                        unsolvedProjectNames.remove(job.getFullName());
                    }
                    StringBuilder missingProject = new StringBuilder();
                    for (String projectName : unsolvedProjectNames) {
                        missingProject.append(" > ");
                        missingProject.append(projectName);
                        missingProject.append("\n");
                    }
                    throw new AbortException("Build aborted. Can't trigger undefined projects. " + nbrOfResolved + " of the below project(s) can't be resolved:\n" + missingProject.toString() + "Check your configuration!");
                }
                if (futures.isEmpty()) {
                    listener.getLogger().println("Triggering projects: " + this.getProjectListAsString(projectList));
                    for (Job p : projectList) {
                        BuildInfoExporterAction.addBuildInfoExporterAction(build, p.getFullName());
                    }
                    continue;
                }
                for (Job p : projectList) {
                    if (!config.canBeScheduled(p)) {
                        User user = User.current();
                        String string = user != null ? ModelHyperlinkNote.encodeTo((User)user) : "unknown";
                        listener.getLogger().println("Skipping " + HyperlinkNote.encodeTo((String)("/" + p.getUrl()), (String)p.getFullDisplayName()) + ". The project is either disabled, or the authenticated user " + string + " has no Item.BUILD permissions, or the configuration has not been saved yet.");
                        continue;
                    }
                    for (QueueTaskFuture queueTaskFuture : futures.get((Object)p)) {
                        try {
                            if (queueTaskFuture != null) {
                                Run startedRun;
                                listener.getLogger().println("Waiting for the completion of " + HyperlinkNote.encodeTo((String)("/" + p.getUrl()), (String)p.getFullDisplayName()));
                                try {
                                    startedRun = (Run)queueTaskFuture.waitForStart();
                                }
                                catch (InterruptedException x) {
                                    listener.getLogger().println("Build aborting: cancelling queued project " + HyperlinkNote.encodeTo((String)("/" + p.getUrl()), (String)p.getFullDisplayName()));
                                    queueTaskFuture.cancel(true);
                                    throw x;
                                }
                                listener.getLogger().println(HyperlinkNote.encodeTo((String)("/" + startedRun.getUrl()), (String)startedRun.getFullDisplayName()) + " started.");
                                Run completedRun = (Run)queueTaskFuture.get();
                                listener.getLogger().println(HyperlinkNote.encodeTo((String)("/" + completedRun.getUrl()), (String)completedRun.getFullDisplayName()) + " completed. Result was " + String.valueOf(completedRun.getResult()));
                                BuildInfoExporterAction.addBuildInfoExporterAction(build, completedRun.getParent().getFullName(), completedRun.getNumber(), completedRun.getResult());
                                if (buildStepResult && config.getBlock().mapBuildStepResult(completedRun.getResult())) {
                                    Result r = config.getBlock().mapBuildResult(completedRun.getResult());
                                    if (r == null) continue;
                                    build.setResult(r);
                                    continue;
                                }
                                buildStepResult = false;
                                continue;
                            }
                            listener.getLogger().println("Skipping " + ModelHyperlinkNote.encodeTo((Item)p) + ". The project was not triggered by some reason.");
                        }
                        catch (CancellationException x) {
                            throw new AbortException(p.getFullDisplayName() + " aborted.");
                        }
                    }
                }
                continue;
                return buildStepResult;
            }
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public String getProjectListAsString(List<Job> projectList) {
        StringBuilder projectListString = new StringBuilder();
        Iterator<Job> iterator = projectList.iterator();
        while (iterator.hasNext()) {
            Job project = iterator.next();
            projectListString.append(HyperlinkNote.encodeTo((String)("/" + project.getUrl()), (String)project.getFullDisplayName()));
            if (!iterator.hasNext()) continue;
            projectListString.append(", ");
        }
        return projectListString.toString();
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.singletonList(new SubProjectsAction(project, this.configs));
    }

    private boolean canDeclare(AbstractProject owner) {
        return !owner.getClass().getName().equals("hudson.plugins.promoted_builds.PromotionProcess");
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (!this.canDeclare(owner)) {
            return;
        }
        for (BuildTriggerConfig buildTriggerConfig : this.configs) {
            List<AbstractProject> projectList = buildTriggerConfig.getProjectList(owner.getParent(), null);
            for (AbstractProject project : projectList) {
                graph.addDependency((DependencyGraph.Dependency)new TriggerBuilderDependency(owner, project, buildTriggerConfig));
            }
        }
    }

    public static class TriggerBuilderDependency
    extends ParameterizedDependency {
        public TriggerBuilderDependency(AbstractProject upstream, AbstractProject downstream, BuildTriggerConfig config) {
            super(upstream, downstream, config);
        }

        @Override
        public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
            return false;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Trigger/call builds on other projects";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

