/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import com.google.common.base.Splitter;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.ParametersDefinitionProperty;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.parameterizedscheduler.Messages;

public class ParameterParser {
    private static final String PARAMETER_SEPARATOR = "%";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String PAIR_SEPARATOR = ";";

    public Map<String, String> parse(String nameValuePairFormattedString) {
        if (nameValuePairFormattedString == null || nameValuePairFormattedString.isBlank()) {
            return Collections.emptyMap();
        }
        String clean = nameValuePairFormattedString.trim();
        if (nameValuePairFormattedString.endsWith(PAIR_SEPARATOR)) {
            clean = clean.substring(0, clean.length() - 1);
        }
        return Splitter.on((String)PAIR_SEPARATOR).trimResults().withKeyValueSeparator(Splitter.on((String)NAME_VALUE_SEPARATOR).limit(2)).split((CharSequence)clean);
    }

    @CheckForNull
    public String checkSanity(String cronTabSpec, ParametersDefinitionProperty parametersDefinitionProperty) {
        String[] cronTabLines;
        for (String cronTabLine : cronTabLines = cronTabSpec.split("\\r?\\n")) {
            int idx = cronTabLine.indexOf(PARAMETER_SEPARATOR);
            if (idx == -1 || idx + 1 >= cronTabLine.length()) continue;
            String split = cronTabLine.substring(idx + 1);
            try {
                Map<String, String> parsedParameters = this.parse(split);
                List parameterDefinitionNames = parametersDefinitionProperty != null ? parametersDefinitionProperty.getParameterDefinitionNames() : Collections.emptyList();
                List parsedKeySet = parsedParameters.keySet().stream().filter(s -> !parameterDefinitionNames.contains(s)).collect(Collectors.toList());
                if (!parsedKeySet.isEmpty()) {
                    return Messages.ParameterizedTimerTrigger_UndefinedParameter(parsedKeySet, parameterDefinitionNames);
                }
                List emptyParameters = parsedParameters.keySet().stream().filter(k -> ((String)parsedParameters.get(k)).isEmpty()).collect(Collectors.toList());
                if (emptyParameters.isEmpty()) continue;
                return Messages.ParameterizedTimerTrigger_EmptyParameter(emptyParameters);
            }
            catch (IllegalArgumentException e) {
                return e.getMessage();
            }
        }
        return null;
    }
}

