// CHECKSTYLE:OFF

package org.jenkinsci.plugins.parameterizedscheduler;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ParameterizedTimerTrigger.EmptyParameter}: {@code You have
     * tried to schedule with empty values for parameters ({0}), is this
     * intentional?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have tried to schedule with empty values for parameters
     *     ({0}), is this intentional?}
     */
    public static String ParameterizedTimerTrigger_EmptyParameter(Object arg0) {
        return holder.format("ParameterizedTimerTrigger.EmptyParameter", arg0);
    }

    /**
     * Key {@code ParameterizedTimerTrigger.EmptyParameter}: {@code You have
     * tried to schedule with empty values for parameters ({0}), is this
     * intentional?}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have tried to schedule with empty values for parameters
     *     ({0}), is this intentional?}
     */
    public static Localizable _ParameterizedTimerTrigger_EmptyParameter(Object arg0) {
        return new Localizable(holder, "ParameterizedTimerTrigger.EmptyParameter", arg0);
    }

    /**
     * Key {@code ParameterizedTimerTrigger.UndefinedParameter}: {@code You
     * have tried to schedule with parameters ({0}), which are not among
     * saved project parameters: {1} }.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have tried to schedule with parameters ({0}), which are not
     *     among saved project parameters: {1} }
     */
    public static String ParameterizedTimerTrigger_UndefinedParameter(Object arg0, Object arg1) {
        return holder.format("ParameterizedTimerTrigger.UndefinedParameter", arg0, arg1);
    }

    /**
     * Key {@code ParameterizedTimerTrigger.UndefinedParameter}: {@code You
     * have tried to schedule with parameters ({0}), which are not among
     * saved project parameters: {1} }.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code You have tried to schedule with parameters ({0}), which are not
     *     among saved project parameters: {1} }
     */
    public static Localizable _ParameterizedTimerTrigger_UndefinedParameter(Object arg0, Object arg1) {
        return new Localizable(holder, "ParameterizedTimerTrigger.UndefinedParameter", arg0, arg1);
    }

    /**
     * Key {@code ParameterizedTimerTrigger.TrailingSemicolon}: {@code I need
     * you to remove that semicolon from the end of the line.}.
     * 
     * @return
     *     {@code I need you to remove that semicolon from the end of the line.}
     */
    public static String ParameterizedTimerTrigger_TrailingSemicolon() {
        return holder.format("ParameterizedTimerTrigger.TrailingSemicolon");
    }

    /**
     * Key {@code ParameterizedTimerTrigger.TrailingSemicolon}: {@code I need
     * you to remove that semicolon from the end of the line.}.
     * 
     * @return
     *     {@code I need you to remove that semicolon from the end of the line.}
     */
    public static Localizable _ParameterizedTimerTrigger_TrailingSemicolon() {
        return new Localizable(holder, "ParameterizedTimerTrigger.TrailingSemicolon");
    }

    /**
     * Key {@code
     * ParameterizedTimerTrigger.TimerTriggerCause.ShortDescription}: {@code
     * Started by timer with parameters: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by timer with parameters: {0}}
     */
    public static String ParameterizedTimerTrigger_TimerTriggerCause_ShortDescription(Object arg0) {
        return holder.format("ParameterizedTimerTrigger.TimerTriggerCause.ShortDescription", arg0);
    }

    /**
     * Key {@code
     * ParameterizedTimerTrigger.TimerTriggerCause.ShortDescription}: {@code
     * Started by timer with parameters: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Started by timer with parameters: {0}}
     */
    public static Localizable _ParameterizedTimerTrigger_TimerTriggerCause_ShortDescription(Object arg0) {
        return new Localizable(holder, "ParameterizedTimerTrigger.TimerTriggerCause.ShortDescription", arg0);
    }

    /**
     * Key {@code ParameterizedTimerTrigger.MissingWhitespace}: {@code You
     * appear to be missing whitespace between * and *.}.
     * 
     * @return
     *     {@code You appear to be missing whitespace between * and *.}
     */
    public static String ParameterizedTimerTrigger_MissingWhitespace() {
        return holder.format("ParameterizedTimerTrigger.MissingWhitespace");
    }

    /**
     * Key {@code ParameterizedTimerTrigger.MissingWhitespace}: {@code You
     * appear to be missing whitespace between * and *.}.
     * 
     * @return
     *     {@code You appear to be missing whitespace between * and *.}
     */
    public static Localizable _ParameterizedTimerTrigger_MissingWhitespace() {
        return new Localizable(holder, "ParameterizedTimerTrigger.MissingWhitespace");
    }

    /**
     * Key {@code ParameterizedTimerTrigger.DisplayName}: {@code Build
     * periodically with parameters}.
     * 
     * @return
     *     {@code Build periodically with parameters}
     */
    public static String ParameterizedTimerTrigger_DisplayName() {
        return holder.format("ParameterizedTimerTrigger.DisplayName");
    }

    /**
     * Key {@code ParameterizedTimerTrigger.DisplayName}: {@code Build
     * periodically with parameters}.
     * 
     * @return
     *     {@code Build periodically with parameters}
     */
    public static Localizable _ParameterizedTimerTrigger_DisplayName() {
        return new Localizable(holder, "ParameterizedTimerTrigger.DisplayName");
    }

}
