/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parameterizedscheduler;

import hudson.scheduler.CronTab;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.plugins.parameterizedscheduler.ParameterParser;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

public class ParameterizedCronTab {
    private final Map<String, String> parameterValues;
    private final CronTabList cronTabList;
    private final CronTab cronTab;

    public ParameterizedCronTab(CronTab cronTab, Map<String, String> parameters) {
        this.cronTabList = new CronTabList(Collections.singleton(cronTab));
        this.parameterValues = parameters;
        this.cronTab = cronTab;
    }

    public static ParameterizedCronTab create(String line, int lineNumber, Hash hash, String timezone) {
        Map<String, String> parameters = new HashMap<String, String>();
        int firstPercentIdx = line.indexOf("%");
        if (firstPercentIdx != -1) {
            String cronLinePart = line.substring(0, firstPercentIdx).trim();
            String paramsLinePart = line.substring(firstPercentIdx + 1).trim();
            CronTab cronTab = new CronTab(cronLinePart, lineNumber, hash, timezone);
            parameters = new ParameterParser().parse(paramsLinePart);
            return new ParameterizedCronTab(cronTab, parameters);
        }
        CronTab cronTab = new CronTab(line, lineNumber, hash, timezone);
        return new ParameterizedCronTab(cronTab, parameters);
    }

    public Map<String, String> getParameterValues() {
        return this.parameterValues;
    }

    public boolean check(Calendar calendar) {
        return this.cronTabList.check(calendar);
    }

    public String checkSanity() {
        return this.cronTabList.checkSanity();
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public Calendar previous() {
        return this.cronTabList.previous();
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public Calendar next() {
        return this.cronTabList.next();
    }

    public Calendar ceil(long timeInMillis) {
        return this.cronTab.ceil(timeInMillis);
    }

    public Calendar floor(long timeInMillis) {
        return this.cronTab.floor(timeInMillis);
    }
}

