/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.parameter_separator;

import com.google.common.base.Strings;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.PersistentDescriptor;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.UUID;
import javax.annotation.Nullable;
import jenkins.plugins.parameter_separator.Messages;
import jenkins.plugins.parameter_separator.ParameterSeparatorValue;
import jenkins.plugins.parameter_separator.Utils;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class ParameterSeparatorDefinition
extends ParameterDefinition {
    @Nullable
    private String separatorStyle;
    @Nullable
    private String sectionHeader;
    @Nullable
    private String sectionHeaderStyle;

    @DataBoundConstructor
    public ParameterSeparatorDefinition(String name, String separatorStyle, String sectionHeader, String sectionHeaderStyle) {
        super((String)(Strings.isNullOrEmpty((String)name) ? "separator-" + UUID.randomUUID().toString() : name));
        this.separatorStyle = Strings.emptyToNull((String)separatorStyle);
        this.sectionHeader = Strings.emptyToNull((String)sectionHeader);
        this.sectionHeaderStyle = Strings.emptyToNull((String)sectionHeaderStyle);
    }

    public String getSeparatorStyle() {
        return this.separatorStyle;
    }

    public String getEffectiveSeparatorStyle() {
        return Utils.getEffectiveSeparatorStyle(this.separatorStyle);
    }

    public String getSectionHeader() {
        return this.sectionHeader;
    }

    public boolean needsSectionHeader() {
        return this.sectionHeader != null;
    }

    public String getFormattedSectionHeader() {
        return Utils.getFormattedSectionHeader(this.sectionHeader);
    }

    public String getSectionHeaderStyle() {
        return this.sectionHeaderStyle;
    }

    public String getEffectiveSectionHeaderStyle() {
        return Utils.getEffectiveSectionHeaderStyle(this.sectionHeaderStyle);
    }

    public ParameterValue getDefaultParameterValue() {
        return new ParameterSeparatorValue(this.getName(), this.separatorStyle, this.sectionHeader, this.sectionHeaderStyle);
    }

    public ParameterValue createValue(StaplerRequest2 request) {
        return this.getDefaultParameterValue();
    }

    public ParameterValue createValue(StaplerRequest2 request, JSONObject jObj) {
        return this.getDefaultParameterValue();
    }

    @Extension
    @Symbol(value={"separator"})
    public static class ParameterSeparatorDescriptor
    extends ParameterDefinition.ParameterDescriptor
    implements PersistentDescriptor {
        private String globalSeparatorStyle = "";
        private String globalSectionHeaderStyle = "font-weight: bold;";

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json.getJSONObject("parameter_separator"));
            return true;
        }

        public String getDisplayName() {
            return Messages.ParameterSeparatorDefinition_DisplayName();
        }

        public String getGlobalSeparatorStyle() {
            return this.globalSeparatorStyle;
        }

        public void setGlobalSeparatorStyle(String globalSeparatorStyle) {
            this.globalSeparatorStyle = globalSeparatorStyle;
            this.save();
        }

        public String getGlobalSectionHeaderStyle() {
            return this.globalSectionHeaderStyle;
        }

        public void setGlobalSectionHeaderStyle(String globalSectionHeaderStyle) {
            this.globalSectionHeaderStyle = globalSectionHeaderStyle;
            this.save();
        }

        public HttpResponse doPreview(@QueryParameter String text, @QueryParameter String separatorStyle, @QueryParameter String sectionHeaderStyle) throws IOException {
            return HttpResponses.literalHtml((String)Utils.getPreview(text, separatorStyle, sectionHeaderStyle));
        }
    }
}

