/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import com.google.common.collect.Lists;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.FileParameterValue;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactory;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameterFactoryDescriptor;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.FileBuildParameterFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.stapler.DataBoundConstructor;

public class MultipleBinaryFileParameterFactory
extends AbstractBuildParameterFactory {
    private final List<ParameterBinding> parametersList;
    private final FileBuildParameterFactory.NoFilesFoundEnum noFilesFoundAction;
    private static final Logger LOGGER = Logger.getLogger(MultipleBinaryFileParameterFactory.class.getName());

    @DataBoundConstructor
    public MultipleBinaryFileParameterFactory(List<ParameterBinding> parametersList, FileBuildParameterFactory.NoFilesFoundEnum noFilesFoundAction) {
        this.parametersList = parametersList;
        this.noFilesFoundAction = noFilesFoundAction;
    }

    public MultipleBinaryFileParameterFactory(List<ParameterBinding> parametersList) {
        this(parametersList, FileBuildParameterFactory.NoFilesFoundEnum.SKIP);
    }

    public FileBuildParameterFactory.NoFilesFoundEnum getNoFilesFoundAction() {
        return this.noFilesFoundAction;
    }

    public List<AbstractBuildParameters> getParameters(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
        ArrayList result = Lists.newArrayList();
        int totalFiles = 0;
        for (final ParameterBinding parameterBinding : this.parametersList) {
            FilePath target = new FilePath(build.getRootDir()).child("parameter-files");
            FilePath workspace = build.getWorkspace();
            if (workspace == null) {
                throw new AbortException("no workspace");
            }
            int k = workspace.copyRecursiveTo(parameterBinding.filePattern, target);
            totalFiles += k;
            if (k <= 0) continue;
            for (final FilePath f : target.list(parameterBinding.filePattern)) {
                LOGGER.fine("Triggering build with " + f.getName());
                result.add(new AbstractBuildParameters(){

                    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
                        assert (f.getChannel() == null);
                        FileParameterValue fv = new FileParameterValue(parameterBinding.parameterName, new File(f.getRemote()), f.getName());
                        return new ParametersAction(new ParameterValue[]{fv});
                    }
                });
            }
        }
        if (totalFiles == 0) {
            this.noFilesFoundAction.failCheck(listener);
        }
        return result;
    }

    public static class ParameterBinding {
        public final String parameterName;
        public final String filePattern;

        public ParameterBinding(String parameterName, String filePattern) {
            this.parameterName = parameterName;
            this.filePattern = filePattern;
        }
    }

    @OptionalExtension(requirePlugins={"parameterized-trigger"})
    public static class DescriptorImpl
    extends AbstractBuildParameterFactoryDescriptor {
        public String getDisplayName() {
            return "Multiple Binary Files (not meant to be used)";
        }
    }
}

