/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.AutoCompletionCandidates;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BlockingBehaviour;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.tasks.junit.JUnitResultArchiver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.jenkinsci.plugins.parallel_test_executor.InclusionExclusionPattern;
import org.jenkinsci.plugins.parallel_test_executor.MultipleBinaryFileParameterFactory;
import org.jenkinsci.plugins.parallel_test_executor.Parallelism;
import org.jenkinsci.plugins.parallel_test_executor.Splitter;
import org.jenkinsci.plugins.parallel_test_executor.TestCollector;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;
import org.jenkinsci.plugins.parallel_test_executor.testmode.TestMode;
import org.jenkinsci.plugins.variant.OptionalExtension;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ParallelTestExecutor
extends Builder {
    private static final Logger LOGGER = Logger.getLogger(ParallelTestExecutor.class.getName());
    public static final int NUMBER_OF_BUILDS_TO_SEARCH = 20;
    public static final ImmutableSet<Result> RESULTS_OF_BUILDS_TO_CONSIDER = ImmutableSet.of((Object)Result.SUCCESS, (Object)Result.UNSTABLE);
    private final Parallelism parallelism;
    private final String testJob;
    private final String patternFile;
    private String includesPatternFile;
    private final String testReportFiles;
    private final boolean doNotArchiveTestResults;
    private final List<AbstractBuildParameters> parameters;
    private TestMode testMode;

    @DataBoundConstructor
    public ParallelTestExecutor(Parallelism parallelism, String testJob, String patternFile, String testReportFiles, boolean archiveTestResults, List<AbstractBuildParameters> parameters) {
        this.parallelism = parallelism;
        this.testJob = testJob;
        this.patternFile = patternFile;
        this.testReportFiles = testReportFiles;
        this.parameters = parameters;
        this.doNotArchiveTestResults = !archiveTestResults;
    }

    public Parallelism getParallelism() {
        return this.parallelism;
    }

    public String getTestJob() {
        return this.testJob;
    }

    public String getPatternFile() {
        return this.patternFile;
    }

    @CheckForNull
    public String getIncludesPatternFile() {
        return this.includesPatternFile;
    }

    @DataBoundSetter
    public void setIncludesPatternFile(String includesPatternFile) {
        this.includesPatternFile = Util.fixEmpty((String)includesPatternFile);
    }

    public String getTestReportFiles() {
        return this.testReportFiles;
    }

    public boolean isArchiveTestResults() {
        return !this.doNotArchiveTestResults;
    }

    public TestMode getTestMode() {
        return TestMode.fixDefault(this.testMode);
    }

    @DataBoundSetter
    public void setTestMode(TestMode testMode) {
        this.testMode = testMode;
    }

    public List<AbstractBuildParameters> getParameters() {
        return this.parameters;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new AbortException("no workspace");
        }
        FilePath dir = workspace.child("test-splits");
        dir.deleteRecursive();
        List<InclusionExclusionPattern> splits = Splitter.findTestSplits(this.parallelism, this.testMode, build, (TaskListener)listener, this.includesPatternFile != null, null, build.getWorkspace());
        for (int i = 0; i < splits.size(); ++i) {
            InclusionExclusionPattern pattern = splits.get(i);
            try (OutputStream os = dir.child("split." + i + "." + (pattern.isIncludes() ? "include" : "exclude") + ".txt").write();
                 OutputStreamWriter osw = new OutputStreamWriter(os, StandardCharsets.UTF_8);
                 PrintWriter pw = new PrintWriter(osw);){
                for (String filePattern : pattern.getList()) {
                    pw.println(filePattern);
                }
                continue;
            }
        }
        this.createTriggerBuilder().perform(build, launcher, listener);
        if (this.isArchiveTestResults()) {
            this.tally(build, launcher, listener);
        }
        return true;
    }

    private void tally(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        new JUnitResultArchiver("test-splits/reports/**/*.xml", false, null).perform(build, launcher, listener);
    }

    private TriggerBuilder createTriggerBuilder() {
        BlockingBehaviour blocking = new BlockingBehaviour(Result.ABORTED, Result.UNSTABLE, Result.FAILURE);
        final AtomicInteger iota = new AtomicInteger(0);
        ArrayList<AbstractBuildParameters> parameterList = new ArrayList<AbstractBuildParameters>();
        parameterList.add(new AbstractBuildParameters(){

            public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) throws IOException, InterruptedException, AbstractBuildParameters.DontTriggerException {
                return new TestCollector(build, ParallelTestExecutor.this, iota.incrementAndGet());
            }
        });
        if (this.parameters != null) {
            parameterList.addAll(this.parameters);
        }
        ArrayList<MultipleBinaryFileParameterFactory.ParameterBinding> parameterBindings = new ArrayList<MultipleBinaryFileParameterFactory.ParameterBinding>();
        parameterBindings.add(new MultipleBinaryFileParameterFactory.ParameterBinding(this.getPatternFile(), "test-splits/split.*.exclude.txt"));
        if (this.includesPatternFile != null) {
            parameterBindings.add(new MultipleBinaryFileParameterFactory.ParameterBinding(this.getIncludesPatternFile(), "test-splits/split.*.include.txt"));
        }
        MultipleBinaryFileParameterFactory factory = new MultipleBinaryFileParameterFactory(parameterBindings);
        BlockableBuildTriggerConfig config = new BlockableBuildTriggerConfig(this.testJob, blocking, Collections.singletonList(factory), parameterList);
        return new TriggerBuilder(new BlockableBuildTriggerConfig[]{config});
    }

    @OptionalExtension(requirePlugins={"parameterized-trigger"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public AutoCompletionCandidates doAutoCompleteTestJob(@QueryParameter String value, @AncestorInPath Item self, @AncestorInPath ItemGroup container) {
            return AutoCompletionCandidates.ofJobNames(AbstractProject.class, (String)value, (Item)self, (ItemGroup)container);
        }

        public String getDisplayName() {
            return "Parallel test job execution";
        }
    }

    @SuppressFBWarnings(value={"EQ_COMPARETO_USE_OBJECT_EQUALS"}, justification="We wish to consider knapsacks as distinct items, just sort by size.")
    static class Knapsack
    implements Comparable<Knapsack> {
        long total;

        Knapsack() {
        }

        void add(TestEntity tc) {
            assert (tc.knapsack == null);
            tc.knapsack = this;
            this.total += tc.duration;
        }

        @Override
        public int compareTo(Knapsack that) {
            long l = this.total - that.total;
            if (l < 0L) {
                return -1;
            }
            if (l > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

