/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import com.google.common.base.Predicate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.console.ModelHyperlinkNote;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.ClassResult;
import hudson.tasks.junit.TestResult;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.tasks.test.TabulatedResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.mixin.ChangeRequestSCMHead;
import org.jenkinsci.plugins.parallel_test_executor.InclusionExclusionPattern;
import org.jenkinsci.plugins.parallel_test_executor.ParallelTestExecutor;
import org.jenkinsci.plugins.parallel_test_executor.Parallelism;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;
import org.jenkinsci.plugins.parallel_test_executor.testmode.TestMode;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;

class Splitter {
    private static final Logger LOGGER = Logger.getLogger(Splitter.class.getName());

    static List<InclusionExclusionPattern> findTestSplits(Parallelism parallelism, @CheckForNull TestMode inputTestMode, Run<?, ?> build, TaskListener listener, boolean generateInclusions, @CheckForNull String stageName, @CheckForNull FilePath workspace) throws InterruptedException {
        TestMode testMode = inputTestMode == null ? TestMode.getDefault() : inputTestMode;
        hudson.tasks.test.TestResult tr = Splitter.findPreviousTestResult(build, listener);
        Map<String, TestEntity> data = new TreeMap<String, TestEntity>();
        if (tr != null) {
            tr = Splitter.mayFilterByStageName(tr, stageName, listener);
            Splitter.collect(tr, data, testMode);
        } else {
            listener.getLogger().println("No record available, try to find test classes");
            data = testMode.estimate(workspace, listener);
            if (data.isEmpty()) {
                listener.getLogger().println("No test classes was found, so executing everything in one place");
                return List.of(new InclusionExclusionPattern(List.of(), false));
            }
        }
        ArrayList<TestEntity> sorted = new ArrayList<TestEntity>(data.values());
        Collections.sort(sorted);
        int n = Math.max(1, parallelism.calculate(sorted));
        ArrayList<ParallelTestExecutor.Knapsack> knapsacks = new ArrayList<ParallelTestExecutor.Knapsack>(n);
        for (int i = 0; i < n; ++i) {
            knapsacks.add(new ParallelTestExecutor.Knapsack());
        }
        PriorityQueue<ParallelTestExecutor.Knapsack> q = new PriorityQueue<ParallelTestExecutor.Knapsack>(knapsacks);
        for (TestEntity testEntity2 : sorted) {
            ParallelTestExecutor.Knapsack k = (ParallelTestExecutor.Knapsack)q.poll();
            k.add(testEntity2);
            q.add(k);
        }
        long total = 0L;
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        for (ParallelTestExecutor.Knapsack k : knapsacks) {
            total += k.total;
            max = Math.max(max, k.total);
            min = Math.min(min, k.total);
        }
        long average = total / (long)n;
        long variance = 0L;
        for (ParallelTestExecutor.Knapsack k : knapsacks) {
            variance += Splitter.pow(k.total - average);
        }
        long stddev = (long)Math.sqrt(variance /= (long)n);
        listener.getLogger().printf("%d test %s (%dms) divided into %d sets. Min=%dms, Average=%dms, Max=%dms, stddev=%dms%n", data.size(), testMode.getWord(), total, n, min, average, max, stddev);
        ArrayList<InclusionExclusionPattern> r = new ArrayList<InclusionExclusionPattern>();
        for (int i = 0; i < n; ++i) {
            ParallelTestExecutor.Knapsack k = (ParallelTestExecutor.Knapsack)knapsacks.get(i);
            boolean shouldIncludeElements = generateInclusions && i != 0;
            List<String> elements = sorted.stream().filter(testEntity -> shouldIncludeElements == (testEntity.knapsack == k)).flatMap(testEntity -> testEntity.getElements().stream()).collect(Collectors.toList());
            r.add(new InclusionExclusionPattern(elements, shouldIncludeElements));
        }
        return r;
    }

    @NonNull
    private static hudson.tasks.test.TestResult mayFilterByStageName(@NonNull hudson.tasks.test.TestResult tr, @CheckForNull String stageName, @NonNull TaskListener listener) {
        Run run = tr.getRun();
        if (stageName != null) {
            listener.getLogger().println("Looking for stage \"" + stageName + "\" in " + run.getFullDisplayName());
            FlowExecution execution = Splitter.resolveFlowExecution(run, listener);
            if (execution != null) {
                FlowNode stageId = new DepthFirstScanner().findFirstMatch(execution, (Predicate)new StageNamePredicate(stageName));
                if (stageId != null) {
                    listener.getLogger().println("Found stage \"" + stageName + "\" in " + run.getFullDisplayName());
                    tr = ((TestResult)tr).getResultForPipelineBlock(stageId.getId());
                } else {
                    listener.getLogger().println("No stage \"" + stageName + "\" found in " + run.getFullDisplayName());
                    TreeSet<String> stages = new TreeSet<String>();
                    for (FlowNode n : new DepthFirstScanner().allNodes(execution)) {
                        LabelAction a = (LabelAction)n.getPersistentAction(LabelAction.class);
                        if (a == null) continue;
                        stages.add(a.getDisplayName());
                    }
                    if (stages.isEmpty()) {
                        listener.getLogger().println("(No possible stages found.)");
                    } else {
                        listener.getLogger().println("(Observed stages: " + stages.stream().collect(Collectors.joining(", ")) + ")");
                    }
                }
            } else {
                listener.getLogger().println("No flow execution found in " + run.getFullDisplayName());
            }
        }
        return tr;
    }

    @CheckForNull
    private static FlowExecution resolveFlowExecution(Run<?, ?> prevRun, TaskListener listener) {
        if (prevRun instanceof FlowExecutionOwner.Executable) {
            FlowExecutionOwner owner = ((FlowExecutionOwner.Executable)prevRun).asFlowExecutionOwner();
            if (owner != null) {
                return owner.getOrNull();
            }
            listener.getLogger().println("No flow execution owner found in " + prevRun.getFullDisplayName());
        } else {
            listener.getLogger().println("Previous run doesn't have the expected type: " + String.valueOf(prevRun));
        }
        return null;
    }

    private static long pow(long l) {
        return l * l;
    }

    private static void collect(hudson.tasks.test.TestResult r, Map<String, TestEntity> data, TestMode testMode) {
        ArrayDeque<hudson.tasks.test.TestResult> queue = new ArrayDeque<hudson.tasks.test.TestResult>();
        queue.push(r);
        while (!queue.isEmpty()) {
            hudson.tasks.test.TestResult current = (hudson.tasks.test.TestResult)queue.pop();
            if (current instanceof ClassResult) {
                ClassResult classResult = (ClassResult)current;
                LOGGER.log(Level.FINE, () -> "Retrieving test entities from " + classResult.getFullName());
                data.putAll(testMode.getTestEntitiesMap(classResult));
                continue;
            }
            if (current instanceof TabulatedResult) {
                LOGGER.log(Level.FINE, () -> "Considering children of " + current.getFullName());
                queue.addAll(((TabulatedResult)current).getChildren());
                continue;
            }
            LOGGER.log(Level.FINE, () -> "Ignoring " + current.getFullName());
        }
    }

    private static hudson.tasks.test.TestResult findPreviousTestResult(Run<?, ?> b, TaskListener listener) {
        SCMHead head;
        Job project = b.getParent();
        hudson.tasks.test.TestResult result = Splitter.getTestResult(project, b.getPreviousBuild(), listener);
        if (result == null && (head = SCMHead.HeadByItem.findHead((Item)project)) instanceof ChangeRequestSCMHead) {
            SCMHead target = ((ChangeRequestSCMHead)head).getTarget();
            Item targetBranch = project.getParent().getItem(target.getName());
            if (targetBranch instanceof Job) {
                result = Splitter.getTestResult(project, ((Job)targetBranch).getLastBuild(), listener);
            }
        }
        return result;
    }

    static hudson.tasks.test.TestResult getTestResult(Job<?, ?> originProject, Run<?, ?> b, TaskListener listener) {
        hudson.tasks.test.TestResult result = null;
        for (int i = 0; i < 20 && b != null; b = b.getPreviousBuild(), ++i) {
            if (!ParallelTestExecutor.RESULTS_OF_BUILDS_TO_CONSIDER.contains((Object)b.getResult()) || b.isBuilding()) continue;
            String hyperlink = ModelHyperlinkNote.encodeTo((String)("/" + b.getUrl()), (String)(originProject != b.getParent() ? b.getFullDisplayName() : b.getDisplayName()));
            try {
                Object o;
                AbstractTestResultAction tra = (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class);
                if (tra == null || !((o = tra.getResult()) instanceof hudson.tasks.test.TestResult)) continue;
                hudson.tasks.test.TestResult tr = (hudson.tasks.test.TestResult)o;
                if (tr.getTotalCount() == 0) {
                    listener.getLogger().printf("Build %s has no loadable test results (supposed count %d), skipping%n", hyperlink, tra.getTotalCount());
                    continue;
                }
                listener.getLogger().printf("Using build %s as reference%n", hyperlink);
                result = tr;
                break;
            }
            catch (RuntimeException e) {
                e.printStackTrace(listener.error("Failed to load (corrupt?) build %s, skipping%n", new Object[]{hyperlink}));
            }
        }
        return result;
    }

    private Splitter() {
    }

    private static class StageNamePredicate
    implements Predicate<FlowNode> {
        private final String stageName;

        StageNamePredicate(@NonNull String stageName) {
            this.stageName = stageName;
        }

        public boolean apply(@Nullable FlowNode input) {
            if (input != null) {
                LabelAction labelAction = (LabelAction)input.getPersistentAction(LabelAction.class);
                return labelAction != null && this.stageName.equals(labelAction.getDisplayName());
            }
            return false;
        }
    }
}

