/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import com.google.common.collect.ImmutableSet;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jenkinsci.plugins.parallel_test_executor.InclusionExclusionPattern;
import org.jenkinsci.plugins.parallel_test_executor.Parallelism;
import org.jenkinsci.plugins.parallel_test_executor.Splitter;
import org.jenkinsci.plugins.parallel_test_executor.testmode.TestMode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class SplitStep
extends Step {
    private final Parallelism parallelism;
    private boolean generateInclusions;
    private String stage;
    private TestMode testMode;

    @DataBoundConstructor
    public SplitStep(Parallelism parallelism) {
        this.parallelism = parallelism;
    }

    public Parallelism getParallelism() {
        return this.parallelism;
    }

    public boolean isGenerateInclusions() {
        return this.generateInclusions;
    }

    @DataBoundSetter
    public void setGenerateInclusions(boolean generateInclusions) {
        this.generateInclusions = generateInclusions;
    }

    public TestMode getTestMode() {
        return TestMode.fixDefault(this.testMode);
    }

    @DataBoundSetter
    public void setTestMode(TestMode testMode) {
        this.testMode = testMode;
    }

    @Deprecated
    @DataBoundSetter
    public void setEstimateTestsFromFiles(boolean estimateTestsFromFiles) {
    }

    @Deprecated
    public boolean isEstimateTestsFromFiles() {
        return false;
    }

    public String getStage() {
        return this.stage;
    }

    @DataBoundSetter
    public void setStage(String stage) {
        this.stage = Util.fixEmpty((String)stage);
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(context, this);
    }

    private static final class Execution
    extends SynchronousStepExecution<List<?>> {
        private static final long serialVersionUID = 1L;
        private final transient SplitStep step;

        Execution(StepContext context, SplitStep step) {
            super(context);
            this.step = step;
        }

        protected List<?> run() throws Exception {
            StepContext context = this.getContext();
            Run build = (Run)context.get(Run.class);
            TaskListener listener = (TaskListener)context.get(TaskListener.class);
            FilePath path = (FilePath)context.get(FilePath.class);
            if (this.step.generateInclusions) {
                return Splitter.findTestSplits(this.step.parallelism, this.step.testMode, build, listener, this.step.generateInclusions, this.step.stage, path);
            }
            ArrayList<List<String>> result = new ArrayList<List<String>>();
            for (InclusionExclusionPattern pattern : Splitter.findTestSplits(this.step.parallelism, this.step.testMode, build, listener, this.step.generateInclusions, this.step.stage, path)) {
                result.add(pattern.getList());
            }
            return result;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(TaskListener.class, Run.class);
        }

        public String getFunctionName() {
            return "splitTests";
        }

        public String getDisplayName() {
            return "Split Test Runs";
        }
    }
}

