/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor.testmode;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.tasks.junit.CaseResult;
import hudson.tasks.junit.ClassResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parallel_test_executor.TestClass;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;
import org.jenkinsci.plugins.parallel_test_executor.testmode.TestMode;
import org.kohsuke.stapler.DataBoundConstructor;

public class JavaClassName
extends TestMode {
    private static final String PATTERNS = String.join((CharSequence)",", List.of("**/src/test/java/**/Test*.java", "**/src/test/java/**/*Test.java", "**/src/test/java/**/*Tests.java", "**/src/test/java/**/*TestCase.java"));
    private static final Pattern TEST = Pattern.compile(".+/src/test/java/(.+)[.]java");

    @DataBoundConstructor
    public JavaClassName() {
    }

    public boolean isSplitByCase() {
        return false;
    }

    public boolean useParameters() {
        return false;
    }

    @Override
    @NonNull
    public Map<String, TestEntity> getTestEntitiesMap(@NonNull ClassResult classResult) {
        if (this.isSplitByCase()) {
            return classResult.getChildren().stream().map(cr -> new JavaTestCase((CaseResult)cr, this.useParameters())).collect(Collectors.toMap(JavaTestCase::getKey, Function.identity(), JavaTestCase::new));
        }
        TestClass testClass = new TestClass(classResult);
        return Map.of(testClass.getKey(), testClass);
    }

    @Override
    public Map<String, TestEntity> estimate(FilePath workspace, @NonNull TaskListener listener) throws InterruptedException {
        if (workspace == null) {
            return Map.of();
        }
        TreeMap<String, TestEntity> data = new TreeMap<String, TestEntity>();
        try {
            for (FilePath test : workspace.list(PATTERNS)) {
                String testPath = test.getRemote().replace('\\', '/');
                Matcher m = TEST.matcher(testPath);
                if (!m.matches() || m.groupCount() != 1) {
                    throw new IllegalStateException(testPath + " didn't match expected format");
                }
                String relativePath = m.group(1);
                data.put(relativePath, new TestClass(relativePath));
            }
        }
        catch (IOException e) {
            e.printStackTrace(listener.error("Unable to determine tests to run from files"));
        }
        return data;
    }

    @Override
    @NonNull
    public String getWord() {
        return this.isSplitByCase() ? "cases" : "classes";
    }

    private static class JavaTestCase
    extends TestEntity {
        private final String output;

        private JavaTestCase(CaseResult cr, boolean useParams) {
            this.output = useParams ? cr.getClassName() + "#" + cr.getName() : cr.getClassName() + "#" + cr.getName().split("\\[")[0];
            this.duration = (long)(cr.getDuration() * 1000.0f);
        }

        private JavaTestCase(TestEntity te1, TestEntity te2) {
            if (!te1.getKey().equals(te2.getKey())) {
                throw new IllegalArgumentException("Test cases must have the same key");
            }
            this.output = te1.getKey();
            this.duration = te1.getDuration() + te2.getDuration();
        }

        @Override
        public String getKey() {
            return this.output;
        }

        @Override
        public List<String> getElements() {
            return List.of(this.output);
        }

        public String toString() {
            return this.output;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaTestCase that = (JavaTestCase)o;
            return Objects.equals(this.output, that.output);
        }

        public int hashCode() {
            return Objects.hash(this.output);
        }
    }

    @Extension
    @Symbol(value={"javaClass"})
    public static class DescriptorImpl
    extends Descriptor<TestMode> {
        @NonNull
        public String getDisplayName() {
            return "By java class name";
        }
    }
}

