/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parallel_test_executor.Parallelism;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;
import org.kohsuke.stapler.DataBoundConstructor;

public class TimeDrivenParallelism
extends Parallelism {
    public final int mins;

    @DataBoundConstructor
    public TimeDrivenParallelism(int mins) {
        this.mins = mins;
    }

    @Override
    public int calculate(List<TestEntity> tests) {
        long total = 0L;
        for (TestEntity test : tests) {
            total += test.duration;
        }
        long chunk = TimeUnit.MINUTES.toMillis(this.mins);
        return (int)((total + chunk - 1L) / chunk);
    }

    @Symbol(value={"time"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<Parallelism> {
        public String getDisplayName() {
            return "Fixed time (minutes) for each batch";
        }
    }
}

