/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import hudson.tasks.junit.ClassResult;
import java.util.List;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;

public class TestClass
extends TestEntity {
    final String className;

    public TestClass(ClassResult cr) {
        Object pkgName = cr.getParent().getName();
        pkgName = ((String)pkgName).equals("(root)") ? "" : (String)pkgName + ".";
        this.className = (String)pkgName + cr.getName();
        this.duration = (long)(cr.getDuration() * 1000.0f);
    }

    public TestClass(String className) {
        this.className = className;
        this.duration = 10L;
    }

    @Override
    public String getKey() {
        return this.className;
    }

    @Override
    public List<String> getElements() {
        String sanitizedClassName = this.className.replace('.', '/');
        return List.of(sanitizedClassName + ".java", sanitizedClassName + ".class");
    }

    public String toString() {
        return this.className + ".extension";
    }
}

