/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.parallel_test_executor;

import hudson.Extension;
import hudson.model.Descriptor;
import java.util.List;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.parallel_test_executor.Parallelism;
import org.jenkinsci.plugins.parallel_test_executor.TestEntity;
import org.kohsuke.stapler.DataBoundConstructor;

public class CountDrivenParallelism
extends Parallelism {
    public final int size;

    @DataBoundConstructor
    public CountDrivenParallelism(int size) {
        this.size = size;
    }

    @Override
    public int calculate(List<TestEntity> tests) {
        return tests == null ? this.size : Math.min(this.size, tests.size());
    }

    @Symbol(value={"count"})
    @Extension
    public static class DescriptorImpl
    extends Descriptor<Parallelism> {
        public String getDisplayName() {
            return "Fixed number of batches";
        }
    }
}

