/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid.impl;

import hudson.Extension;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.OpenIdExtension;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;

@Extension
public class UserInfoExtension
extends OpenIdExtension {
    @Override
    public void extendFetch(FetchRequest fetch) throws MessageException {
        fetch.addAttribute("email", "http://axschema.org/contact/email", true);
        fetch.addAttribute("email2", "http://schema.openid.net/contact/email", true);
        fetch.addAttribute("email3", "http://openid.net/schema/contact/email", true);
        fetch.addAttribute("firstName", "http://axschema.org/namePerson/first", true);
        fetch.addAttribute("lastName", "http://axschema.org/namePerson/last", true);
        fetch.addAttribute("nickName", "http://axschema.org/namePerson/friendly", false);
        fetch.addAttribute("ff", "http://axschema.org/namePerson", false);
        fetch.addAttribute("img", "http://axschema.org/media/image/default/", false);
    }

    @Override
    public void extend(AuthRequest authRequest) throws MessageException {
        SRegRequest sregReq = SRegRequest.createFetchRequest();
        sregReq.addAttribute("fullname", true);
        sregReq.addAttribute("nickname", true);
        sregReq.addAttribute("email", true);
        authRequest.addExtension((MessageExtension)sregReq);
    }

    @Override
    public void process(AuthSuccess authSuccess, Identity id) throws MessageException {
        String nick = null;
        Object fullName = null;
        String email = null;
        try {
            SRegResponse sr = this.getMessageAs(SRegResponse.class, authSuccess, "http://openid.net/sreg/1.0");
            nick = sr.getAttributeValue("nickname");
            fullName = sr.getAttributeValue("fullname");
            email = sr.getAttributeValue("email");
        }
        catch (MessageException sr) {
            // empty catch block
        }
        try {
            FetchResponse fr = this.getMessageAs(FetchResponse.class, authSuccess, "http://openid.net/srv/ax/1.0");
            if (fr != null) {
                if (fullName == null) {
                    String first = fr.getAttributeValue("firstName");
                    String last = fr.getAttributeValue("lastName");
                    if (first != null && last != null) {
                        fullName = first + " " + last;
                    }
                }
                if (email == null) {
                    email = fr.getAttributeValue("email");
                }
                if (email == null) {
                    email = fr.getAttributeValue("email2");
                }
                if (email == null) {
                    email = fr.getAttributeValue("email3");
                }
                if (nick == null) {
                    nick = fr.getAttributeValue("nickName");
                }
            }
        }
        catch (MessageException messageException) {
            // empty catch block
        }
        if (nick != null) {
            id.setNick(nick);
        }
        if (fullName != null) {
            id.setFullName((String)fullName);
        }
        if (email != null) {
            id.setEmail(email);
        }
    }
}

