/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.openid;

import com.cloudbees.openid4java.team.TeamExtensionFactory;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.User;
import hudson.plugins.openid.Identity;
import hudson.plugins.openid.Messages;
import hudson.plugins.openid.OpenIdExtension;
import hudson.plugins.openid.OpenIdSession;
import hudson.plugins.openid.OpenIdSsoUserDetails;
import hudson.plugins.openid.OpenIdUserProperty;
import hudson.plugins.openid.YadisResolver2;
import hudson.security.SecurityRealm;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.openid4java.OpenIDException;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.openid4java.consumer.ConsumerException;
import org.openid4java.consumer.ConsumerManager;
import org.openid4java.consumer.InMemoryConsumerAssociationStore;
import org.openid4java.consumer.InMemoryNonceVerifier;
import org.openid4java.consumer.NonceVerifier;
import org.openid4java.discovery.Discovery;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.yadis.YadisResolver;
import org.openid4java.server.RealmVerifierFactory;
import org.openid4java.util.HttpClientFactory;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.ProxyProperties;

public class OpenIdSsoSecurityRealm
extends SecurityRealm {
    private volatile transient ConsumerManager manager;
    public final String endpoint;

    @DataBoundConstructor
    public OpenIdSsoSecurityRealm(String endpoint) throws IOException, OpenIDException {
        this.endpoint = endpoint;
        this.addProxyPropertiesToHttpClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConsumerManager getManager() throws ConsumerException {
        if (this.manager != null) {
            return this.manager;
        }
        OpenIdSsoSecurityRealm openIdSsoSecurityRealm = this;
        synchronized (openIdSsoSecurityRealm) {
            if (this.manager == null) {
                ConsumerManager managerInitializer = this.createManager();
                managerInitializer.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
                managerInitializer.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
                this.manager = managerInitializer;
            }
        }
        return this.manager;
    }

    protected ConsumerManager createManager() throws ConsumerException {
        HttpFetcherFactory fetcherFactory = new HttpFetcherFactory();
        YadisResolver2 resolver = new YadisResolver2(fetcherFactory);
        ConsumerManager manager = new ConsumerManager(new RealmVerifierFactory((YadisResolver)resolver), new Discovery(), fetcherFactory);
        manager.setAssociations((ConsumerAssociationStore)new InMemoryConsumerAssociationStore());
        manager.setNonceVerifier((NonceVerifier)new InMemoryNonceVerifier(5000));
        manager.getDiscovery().setYadisResolver((YadisResolver)resolver);
        return manager;
    }

    protected void addProxyPropertiesToHttpClient() {
        Jenkins instance = Jenkins.get();
        if (instance.proxy != null) {
            ProxyProperties props = new ProxyProperties();
            props.setProxyHostName(instance.proxy.name);
            props.setProxyPort(instance.proxy.port);
            if (instance.proxy.getUserName() != null) {
                props.setUserName(instance.proxy.getUserName());
                props.setPassword(instance.proxy.getPassword());
            }
            HttpClientFactory.setProxyProperties((ProxyProperties)props);
        }
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(authentication -> {
            if (authentication instanceof AnonymousAuthenticationToken) {
                return authentication;
            }
            throw new BadCredentialsException("Unexpected authentication type: " + String.valueOf(authentication));
        });
    }

    public HttpResponse doCommenceLogin(@QueryParameter String from) throws IOException, OpenIDException {
        if (from == null || !from.startsWith("/")) {
            StaplerRequest2 currentRequest = Stapler.getCurrentRequest2();
            from = currentRequest.getHeader("Referer") != null ? currentRequest.getHeader("Referer") : Jenkins.get().getRootUrl();
        }
        final String referer = from;
        return new OpenIdSession(this.getManager(), this.endpoint, "securityRealm/finishLogin"){

            @Override
            protected HttpResponse onSuccess(Identity id) throws IOException {
                GrantedAuthority[] grantedAuthorities;
                List<GrantedAuthority> grantedAuthoritiesList;
                User u = User.get((String)id.getEffectiveNick());
                id.updateProfile(u);
                OpenIdUserProperty p = (OpenIdUserProperty)u.getProperty(OpenIdUserProperty.class);
                if (p != null) {
                    p.addIdentifier(id.getOpenId());
                }
                if ((grantedAuthoritiesList = id.getGrantedAuthorities()).isEmpty()) {
                    grantedAuthorities = new GrantedAuthority[]{SecurityRealm.AUTHENTICATED_AUTHORITY};
                } else {
                    ArrayList<GrantedAuthority> grantedAuthorityWithTextualExpression = new ArrayList<GrantedAuthority>(grantedAuthoritiesList.size());
                    for (GrantedAuthority grantedAuthority : grantedAuthoritiesList) {
                        String textualExpressionOfGrantedAuthority = grantedAuthority.getAuthority();
                        if (textualExpressionOfGrantedAuthority == null || textualExpressionOfGrantedAuthority.isEmpty()) continue;
                        grantedAuthorityWithTextualExpression.add(grantedAuthority);
                    }
                    grantedAuthorities = grantedAuthorityWithTextualExpression.toArray(new GrantedAuthority[0]);
                }
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)u.getId(), (Object)"", grantedAuthorities);
                SecurityContextHolder.getContext().setAuthentication((Authentication)token);
                OpenIdSsoUserDetails userDetails = new OpenIdSsoUserDetails(u.getId(), grantedAuthorities);
                SecurityListener.fireAuthenticated((UserDetails)userDetails);
                return new HttpRedirect(referer);
            }
        }.doCommenceLogin();
    }

    public HttpResponse doFinishLogin(StaplerRequest2 request) throws IOException, OpenIDException {
        OpenIdSession session = OpenIdSession.getCurrent();
        if (session == null) {
            throw new Failure(Messages.OpenIdLoginService_SessionNotFound());
        }
        return session.doFinishLogin(request);
    }

    public boolean isApplicable(OpenIdExtension openIdExtension) {
        return true;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getDisplayName() {
            return "OpenID SSO";
        }

        @RequirePOST
        public FormValidation doValidate(@QueryParameter String endpoint) throws Exception {
            if (!Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                new Discovery().discover(endpoint);
                return FormValidation.ok((String)"OK");
            }
            catch (DiscoveryException e) {
                return FormValidation.error((Throwable)e, (String)("Invalid provider URL: " + endpoint));
            }
        }

        static {
            TeamExtensionFactory.install();
        }
    }
}

