// CHECKSTYLE:OFF

package org.jenkinsci.plugins.oic;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code OicSecurityRealm.EndSessionURLKeyRequired}: {@code End
     * Session URL Key is required.}.
     * 
     * @return
     *     {@code End Session URL Key is required.}
     */
    public static String OicSecurityRealm_EndSessionURLKeyRequired() {
        return holder.format("OicSecurityRealm.EndSessionURLKeyRequired");
    }

    /**
     * Key {@code OicSecurityRealm.EndSessionURLKeyRequired}: {@code End
     * Session URL Key is required.}.
     * 
     * @return
     *     {@code End Session URL Key is required.}
     */
    public static Localizable _OicSecurityRealm_EndSessionURLKeyRequired() {
        return new Localizable(holder, "OicSecurityRealm.EndSessionURLKeyRequired");
    }

    /**
     * Key {@code OicSecurityRealm.EscapeHatchFipsMode}: {@code Escape hatch
     * can''t be used in FIPS mode}.
     * 
     * @return
     *     {@code Escape hatch can''t be used in FIPS mode}
     */
    public static String OicSecurityRealm_EscapeHatchFipsMode() {
        return holder.format("OicSecurityRealm.EscapeHatchFipsMode");
    }

    /**
     * Key {@code OicSecurityRealm.EscapeHatchFipsMode}: {@code Escape hatch
     * can''t be used in FIPS mode}.
     * 
     * @return
     *     {@code Escape hatch can''t be used in FIPS mode}
     */
    public static Localizable _OicSecurityRealm_EscapeHatchFipsMode() {
        return new Localizable(holder, "OicSecurityRealm.EscapeHatchFipsMode");
    }

    /**
     * Key {@code OicSecurityRealm.TokenAuthMethodRequired}: {@code Token
     * auth method is required.}.
     * 
     * @return
     *     {@code Token auth method is required.}
     */
    public static String OicSecurityRealm_TokenAuthMethodRequired() {
        return holder.format("OicSecurityRealm.TokenAuthMethodRequired");
    }

    /**
     * Key {@code OicSecurityRealm.TokenAuthMethodRequired}: {@code Token
     * auth method is required.}.
     * 
     * @return
     *     {@code Token auth method is required.}
     */
    public static Localizable _OicSecurityRealm_TokenAuthMethodRequired() {
        return new Localizable(holder, "OicSecurityRealm.TokenAuthMethodRequired");
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotRetreiveWellKnownConfig}: {@code
     * Could not retrieve well-known config {0,number,integer} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Could not retrieve well-known config {0,number,integer} {1}}
     */
    public static String OicSecurityRealm_CouldNotRetreiveWellKnownConfig(Object arg0, Object arg1) {
        return holder.format("OicSecurityRealm.CouldNotRetreiveWellKnownConfig", arg0, arg1);
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotRetreiveWellKnownConfig}: {@code
     * Could not retrieve well-known config {0,number,integer} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code Could not retrieve well-known config {0,number,integer} {1}}
     */
    public static Localizable _OicSecurityRealm_CouldNotRetreiveWellKnownConfig(Object arg0, Object arg1) {
        return new Localizable(holder, "OicSecurityRealm.CouldNotRetreiveWellKnownConfig", arg0, arg1);
    }

    /**
     * Key {@code OicSecurityRealm.ScopesRequired}: {@code Scopes is
     * required.}.
     * 
     * @return
     *     {@code Scopes is required.}
     */
    public static String OicSecurityRealm_ScopesRequired() {
        return holder.format("OicSecurityRealm.ScopesRequired");
    }

    /**
     * Key {@code OicSecurityRealm.ScopesRequired}: {@code Scopes is
     * required.}.
     * 
     * @return
     *     {@code Scopes is required.}
     */
    public static Localizable _OicSecurityRealm_ScopesRequired() {
        return new Localizable(holder, "OicSecurityRealm.ScopesRequired");
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotParseResponse}: {@code Could not
     * parse response}.
     * 
     * @return
     *     {@code Could not parse response}
     */
    public static String OicSecurityRealm_CouldNotParseResponse() {
        return holder.format("OicSecurityRealm.CouldNotParseResponse");
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotParseResponse}: {@code Could not
     * parse response}.
     * 
     * @return
     *     {@code Could not parse response}
     */
    public static Localizable _OicSecurityRealm_CouldNotParseResponse() {
        return new Localizable(holder, "OicSecurityRealm.CouldNotParseResponse");
    }

    /**
     * Key {@code OicQueryParameterConfiguration.QueryParameterNameRequired}:
     * {@code Query parameter name is required.}.
     * 
     * @return
     *     {@code Query parameter name is required.}
     */
    public static String OicQueryParameterConfiguration_QueryParameterNameRequired() {
        return holder.format("OicQueryParameterConfiguration.QueryParameterNameRequired");
    }

    /**
     * Key {@code OicQueryParameterConfiguration.QueryParameterNameRequired}:
     * {@code Query parameter name is required.}.
     * 
     * @return
     *     {@code Query parameter name is required.}
     */
    public static Localizable _OicQueryParameterConfiguration_QueryParameterNameRequired() {
        return new Localizable(holder, "OicQueryParameterConfiguration.QueryParameterNameRequired");
    }

    /**
     * Key {@code OicSecurityRealm.IdTokenParseError}: {@code Idtoken could
     * not be parsed.}.
     * 
     * @return
     *     {@code Idtoken could not be parsed.}
     */
    public static String OicSecurityRealm_IdTokenParseError() {
        return holder.format("OicSecurityRealm.IdTokenParseError");
    }

    /**
     * Key {@code OicSecurityRealm.IdTokenParseError}: {@code Idtoken could
     * not be parsed.}.
     * 
     * @return
     *     {@code Idtoken could not be parsed.}
     */
    public static Localizable _OicSecurityRealm_IdTokenParseError() {
        return new Localizable(holder, "OicSecurityRealm.IdTokenParseError");
    }

    /**
     * Key {@code OicSecurityRealm.NoIdTokenInResponse}: {@code No idtoken
     * was provided in response to token request.}.
     * 
     * @return
     *     {@code No idtoken was provided in response to token request.}
     */
    public static String OicSecurityRealm_NoIdTokenInResponse() {
        return holder.format("OicSecurityRealm.NoIdTokenInResponse");
    }

    /**
     * Key {@code OicSecurityRealm.NoIdTokenInResponse}: {@code No idtoken
     * was provided in response to token request.}.
     * 
     * @return
     *     {@code No idtoken was provided in response to token request.}
     */
    public static Localizable _OicSecurityRealm_NoIdTokenInResponse() {
        return new Localizable(holder, "OicSecurityRealm.NoIdTokenInResponse");
    }

    /**
     * Key {@code OicSecurityRealm.DisableSslVerificationFipsMode}: {@code
     * SSL verification can not be disabled in FIPS mode}.
     * 
     * @return
     *     {@code SSL verification can not be disabled in FIPS mode}
     */
    public static String OicSecurityRealm_DisableSslVerificationFipsMode() {
        return holder.format("OicSecurityRealm.DisableSslVerificationFipsMode");
    }

    /**
     * Key {@code OicSecurityRealm.DisableSslVerificationFipsMode}: {@code
     * SSL verification can not be disabled in FIPS mode}.
     * 
     * @return
     *     {@code SSL verification can not be disabled in FIPS mode}
     */
    public static Localizable _OicSecurityRealm_DisableSslVerificationFipsMode() {
        return new Localizable(holder, "OicSecurityRealm.DisableSslVerificationFipsMode");
    }

    /**
     * Key {@code OicSecurityRealm.SSLErrorRetreivingWellKnownConfig}: {@code
     * The server presented an invalid or incorrect TLS certificate.}.
     * 
     * @return
     *     {@code The server presented an invalid or incorrect TLS certificate.}
     */
    public static String OicSecurityRealm_SSLErrorRetreivingWellKnownConfig() {
        return holder.format("OicSecurityRealm.SSLErrorRetreivingWellKnownConfig");
    }

    /**
     * Key {@code OicSecurityRealm.SSLErrorRetreivingWellKnownConfig}: {@code
     * The server presented an invalid or incorrect TLS certificate.}.
     * 
     * @return
     *     {@code The server presented an invalid or incorrect TLS certificate.}
     */
    public static Localizable _OicSecurityRealm_SSLErrorRetreivingWellKnownConfig() {
        return new Localizable(holder, "OicSecurityRealm.SSLErrorRetreivingWellKnownConfig");
    }

    /**
     * Key {@code
     * OicQueryParameterConfiguration.QueryParameterValueRequired}: {@code
     * Query parameter value is required.}.
     * 
     * @return
     *     {@code Query parameter value is required.}
     */
    public static String OicQueryParameterConfiguration_QueryParameterValueRequired() {
        return holder.format("OicQueryParameterConfiguration.QueryParameterValueRequired");
    }

    /**
     * Key {@code
     * OicQueryParameterConfiguration.QueryParameterValueRequired}: {@code
     * Query parameter value is required.}.
     * 
     * @return
     *     {@code Query parameter value is required.}
     */
    public static Localizable _OicQueryParameterConfiguration_QueryParameterValueRequired() {
        return new Localizable(holder, "OicQueryParameterConfiguration.QueryParameterValueRequired");
    }

    /**
     * Key {@code OicSecurityRealm.NotAValidURL}: {@code Not a valid url.}.
     * 
     * @return
     *     {@code Not a valid url.}
     */
    public static String OicSecurityRealm_NotAValidURL() {
        return holder.format("OicSecurityRealm.NotAValidURL");
    }

    /**
     * Key {@code OicSecurityRealm.NotAValidURL}: {@code Not a valid url.}.
     * 
     * @return
     *     {@code Not a valid url.}
     */
    public static Localizable _OicSecurityRealm_NotAValidURL() {
        return new Localizable(holder, "OicSecurityRealm.NotAValidURL");
    }

    /**
     * Key {@code OicSecurityRealm.URLNotAOpenIdEnpoint}: {@code URL does not
     * seem to describe OpenID Connect endpoints}.
     * 
     * @return
     *     {@code URL does not seem to describe OpenID Connect endpoints}
     */
    public static String OicSecurityRealm_URLNotAOpenIdEnpoint() {
        return holder.format("OicSecurityRealm.URLNotAOpenIdEnpoint");
    }

    /**
     * Key {@code OicSecurityRealm.URLNotAOpenIdEnpoint}: {@code URL does not
     * seem to describe OpenID Connect endpoints}.
     * 
     * @return
     *     {@code URL does not seem to describe OpenID Connect endpoints}
     */
    public static Localizable _OicSecurityRealm_URLNotAOpenIdEnpoint() {
        return new Localizable(holder, "OicSecurityRealm.URLNotAOpenIdEnpoint");
    }

    /**
     * Key {@code OicSecurityRealm.RUSureOpenIdNotInScope}: {@code Are you
     * sure you don''t want to include ''openid'' as a scope?}.
     * 
     * @return
     *     {@code Are you sure you don''t want to include ''openid'' as a scope?}
     */
    public static String OicSecurityRealm_RUSureOpenIdNotInScope() {
        return holder.format("OicSecurityRealm.RUSureOpenIdNotInScope");
    }

    /**
     * Key {@code OicSecurityRealm.RUSureOpenIdNotInScope}: {@code Are you
     * sure you don''t want to include ''openid'' as a scope?}.
     * 
     * @return
     *     {@code Are you sure you don''t want to include ''openid'' as a scope?}
     */
    public static Localizable _OicSecurityRealm_RUSureOpenIdNotInScope() {
        return new Localizable(holder, "OicSecurityRealm.RUSureOpenIdNotInScope");
    }

    /**
     * Key {@code OicServerWellKnownConfiguration.DisplayName}: {@code
     * Discovery via well-known endpoint}.
     * 
     * @return
     *     {@code Discovery via well-known endpoint}
     */
    public static String OicServerWellKnownConfiguration_DisplayName() {
        return holder.format("OicServerWellKnownConfiguration.DisplayName");
    }

    /**
     * Key {@code OicServerWellKnownConfiguration.DisplayName}: {@code
     * Discovery via well-known endpoint}.
     * 
     * @return
     *     {@code Discovery via well-known endpoint}
     */
    public static Localizable _OicServerWellKnownConfiguration_DisplayName() {
        return new Localizable(holder, "OicServerWellKnownConfiguration.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.DisplayName}: {@code Login with Openid
     * Connect}.
     * 
     * @return
     *     {@code Login with Openid Connect}
     */
    public static String OicSecurityRealm_DisplayName() {
        return holder.format("OicSecurityRealm.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.DisplayName}: {@code Login with Openid
     * Connect}.
     * 
     * @return
     *     {@code Login with Openid Connect}
     */
    public static Localizable _OicSecurityRealm_DisplayName() {
        return new Localizable(holder, "OicSecurityRealm.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.TokenRefreshFailure}: {@code Unable to
     * refresh access token}.
     * 
     * @return
     *     {@code Unable to refresh access token}
     */
    public static String OicSecurityRealm_TokenRefreshFailure() {
        return holder.format("OicSecurityRealm.TokenRefreshFailure");
    }

    /**
     * Key {@code OicSecurityRealm.TokenRefreshFailure}: {@code Unable to
     * refresh access token}.
     * 
     * @return
     *     {@code Unable to refresh access token}
     */
    public static Localizable _OicSecurityRealm_TokenRefreshFailure() {
        return new Localizable(holder, "OicSecurityRealm.TokenRefreshFailure");
    }

    /**
     * Key {@code OicSecurityRealm.monitor.DisplayName}: {@code Openid
     * Connect Id Strategy Configuration}.
     * 
     * @return
     *     {@code Openid Connect Id Strategy Configuration}
     */
    public static String OicSecurityRealm_monitor_DisplayName() {
        return holder.format("OicSecurityRealm.monitor.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.monitor.DisplayName}: {@code Openid
     * Connect Id Strategy Configuration}.
     * 
     * @return
     *     {@code Openid Connect Id Strategy Configuration}
     */
    public static Localizable _OicSecurityRealm_monitor_DisplayName() {
        return new Localizable(holder, "OicSecurityRealm.monitor.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.InvalidFieldName}: {@code Invalid field
     * name - must be a valid JMESPath expression.}.
     * 
     * @return
     *     {@code Invalid field name - must be a valid JMESPath expression.}
     */
    public static String OicSecurityRealm_InvalidFieldName() {
        return holder.format("OicSecurityRealm.InvalidFieldName");
    }

    /**
     * Key {@code OicSecurityRealm.InvalidFieldName}: {@code Invalid field
     * name - must be a valid JMESPath expression.}.
     * 
     * @return
     *     {@code Invalid field name - must be a valid JMESPath expression.}
     */
    public static Localizable _OicSecurityRealm_InvalidFieldName() {
        return new Localizable(holder, "OicSecurityRealm.InvalidFieldName");
    }

    /**
     * Key {@code OicSecurityRealm.ClientSecretRequired}: {@code Client
     * secret is required.}.
     * 
     * @return
     *     {@code Client secret is required.}
     */
    public static String OicSecurityRealm_ClientSecretRequired() {
        return holder.format("OicSecurityRealm.ClientSecretRequired");
    }

    /**
     * Key {@code OicSecurityRealm.ClientSecretRequired}: {@code Client
     * secret is required.}.
     * 
     * @return
     *     {@code Client secret is required.}
     */
    public static Localizable _OicSecurityRealm_ClientSecretRequired() {
        return new Localizable(holder, "OicSecurityRealm.ClientSecretRequired");
    }

    /**
     * Key {@code OicSecurityRealm.DisableTokenVerificationFipsMode}: {@code
     * Token verification can not be disabled in FIPS mode}.
     * 
     * @return
     *     {@code Token verification can not be disabled in FIPS mode}
     */
    public static String OicSecurityRealm_DisableTokenVerificationFipsMode() {
        return holder.format("OicSecurityRealm.DisableTokenVerificationFipsMode");
    }

    /**
     * Key {@code OicSecurityRealm.DisableTokenVerificationFipsMode}: {@code
     * Token verification can not be disabled in FIPS mode}.
     * 
     * @return
     *     {@code Token verification can not be disabled in FIPS mode}
     */
    public static Localizable _OicSecurityRealm_DisableTokenVerificationFipsMode() {
        return new Localizable(holder, "OicSecurityRealm.DisableTokenVerificationFipsMode");
    }

    /**
     * Key {@code OicServerManualConfiguration.DisplayName}: {@code Manual
     * entry}.
     * 
     * @return
     *     {@code Manual entry}
     */
    public static String OicServerManualConfiguration_DisplayName() {
        return holder.format("OicServerManualConfiguration.DisplayName");
    }

    /**
     * Key {@code OicServerManualConfiguration.DisplayName}: {@code Manual
     * entry}.
     * 
     * @return
     *     {@code Manual entry}
     */
    public static Localizable _OicServerManualConfiguration_DisplayName() {
        return new Localizable(holder, "OicServerManualConfiguration.DisplayName");
    }

    /**
     * Key {@code OicSecurityRealm.IssuerRequired}: {@code Issuer is
     * required.}.
     * 
     * @return
     *     {@code Issuer is required.}
     */
    public static String OicSecurityRealm_IssuerRequired() {
        return holder.format("OicSecurityRealm.IssuerRequired");
    }

    /**
     * Key {@code OicSecurityRealm.IssuerRequired}: {@code Issuer is
     * required.}.
     * 
     * @return
     *     {@code Issuer is required.}
     */
    public static Localizable _OicSecurityRealm_IssuerRequired() {
        return new Localizable(holder, "OicSecurityRealm.IssuerRequired");
    }

    /**
     * Key {@code OicSecurityRealm.ClientIdRequired}: {@code Client id is
     * required.}.
     * 
     * @return
     *     {@code Client id is required.}
     */
    public static String OicSecurityRealm_ClientIdRequired() {
        return holder.format("OicSecurityRealm.ClientIdRequired");
    }

    /**
     * Key {@code OicSecurityRealm.ClientIdRequired}: {@code Client id is
     * required.}.
     * 
     * @return
     *     {@code Client id is required.}
     */
    public static Localizable _OicSecurityRealm_ClientIdRequired() {
        return new Localizable(holder, "OicSecurityRealm.ClientIdRequired");
    }

    /**
     * Key {@code OicSecurityRealm.ErrorRetreivingWellKnownConfig}: {@code
     * Error when retrieving well-known config}.
     * 
     * @return
     *     {@code Error when retrieving well-known config}
     */
    public static String OicSecurityRealm_ErrorRetreivingWellKnownConfig() {
        return holder.format("OicSecurityRealm.ErrorRetreivingWellKnownConfig");
    }

    /**
     * Key {@code OicSecurityRealm.ErrorRetreivingWellKnownConfig}: {@code
     * Error when retrieving well-known config}.
     * 
     * @return
     *     {@code Error when retrieving well-known config}
     */
    public static Localizable _OicSecurityRealm_ErrorRetreivingWellKnownConfig() {
        return new Localizable(holder, "OicSecurityRealm.ErrorRetreivingWellKnownConfig");
    }

    /**
     * Key {@code OicSecurityRealm.UsingDefaultUsername}: {@code Using
     * ''sub''.}.
     * 
     * @return
     *     {@code Using ''sub''.}
     */
    public static String OicSecurityRealm_UsingDefaultUsername() {
        return holder.format("OicSecurityRealm.UsingDefaultUsername");
    }

    /**
     * Key {@code OicSecurityRealm.UsingDefaultUsername}: {@code Using
     * ''sub''.}.
     * 
     * @return
     *     {@code Using ''sub''.}
     */
    public static Localizable _OicSecurityRealm_UsingDefaultUsername() {
        return new Localizable(holder, "OicSecurityRealm.UsingDefaultUsername");
    }

    /**
     * Key {@code OicLogoutAction.OicLogout}: {@code Oic Logout}.
     * 
     * @return
     *     {@code Oic Logout}
     */
    public static String OicLogoutAction_OicLogout() {
        return holder.format("OicLogoutAction.OicLogout");
    }

    /**
     * Key {@code OicLogoutAction.OicLogout}: {@code Oic Logout}.
     * 
     * @return
     *     {@code Oic Logout}
     */
    public static Localizable _OicLogoutAction_OicLogout() {
        return new Localizable(holder, "OicLogoutAction.OicLogout");
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotRefreshToken}: {@code Unable to
     * refresh access token}.
     * 
     * @return
     *     {@code Unable to refresh access token}
     */
    public static String OicSecurityRealm_CouldNotRefreshToken() {
        return holder.format("OicSecurityRealm.CouldNotRefreshToken");
    }

    /**
     * Key {@code OicSecurityRealm.CouldNotRefreshToken}: {@code Unable to
     * refresh access token}.
     * 
     * @return
     *     {@code Unable to refresh access token}
     */
    public static Localizable _OicSecurityRealm_CouldNotRefreshToken() {
        return new Localizable(holder, "OicSecurityRealm.CouldNotRefreshToken");
    }

    /**
     * Key {@code OicSecurityRealm.TokenServerURLKeyRequired}: {@code Token
     * Server Url Key is required.}.
     * 
     * @return
     *     {@code Token Server Url Key is required.}
     */
    public static String OicSecurityRealm_TokenServerURLKeyRequired() {
        return holder.format("OicSecurityRealm.TokenServerURLKeyRequired");
    }

    /**
     * Key {@code OicSecurityRealm.TokenServerURLKeyRequired}: {@code Token
     * Server Url Key is required.}.
     * 
     * @return
     *     {@code Token Server Url Key is required.}
     */
    public static Localizable _OicSecurityRealm_TokenServerURLKeyRequired() {
        return new Localizable(holder, "OicSecurityRealm.TokenServerURLKeyRequired");
    }

    /**
     * Key {@code OicSecurityRealm.TokenRequestFailure}: {@code Token request
     * failed: {0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token request failed: {0}"}
     */
    public static String OicSecurityRealm_TokenRequestFailure(Object arg0) {
        return holder.format("OicSecurityRealm.TokenRequestFailure", arg0);
    }

    /**
     * Key {@code OicSecurityRealm.TokenRequestFailure}: {@code Token request
     * failed: {0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token request failed: {0}"}
     */
    public static Localizable _OicSecurityRealm_TokenRequestFailure(Object arg0) {
        return new Localizable(holder, "OicSecurityRealm.TokenRequestFailure", arg0);
    }

    /**
     * Key {@code OicSecurityRealm.UsernameNotFound}: {@code No field ''{0}''
     * was supplied in the UserInfo or the IdToken payload to be used as the
     * username.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No field ''{0}'' was supplied in the UserInfo or the IdToken
     *     payload to be used as the username.}
     */
    public static String OicSecurityRealm_UsernameNotFound(Object arg0) {
        return holder.format("OicSecurityRealm.UsernameNotFound", arg0);
    }

    /**
     * Key {@code OicSecurityRealm.UsernameNotFound}: {@code No field ''{0}''
     * was supplied in the UserInfo or the IdToken payload to be used as the
     * username.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No field ''{0}'' was supplied in the UserInfo or the IdToken
     *     payload to be used as the username.}
     */
    public static Localizable _OicSecurityRealm_UsernameNotFound(Object arg0) {
        return new Localizable(holder, "OicSecurityRealm.UsernameNotFound", arg0);
    }

}
