/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic.properties;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import org.jenkinsci.plugins.oic.OicServerConfiguration;
import org.jenkinsci.plugins.oic.OidcProperty;
import org.jenkinsci.plugins.oic.OidcPropertyDescriptor;
import org.jenkinsci.plugins.oic.OidcPropertyExecution;
import org.jenkinsci.plugins.oic.properties.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.pac4j.oidc.config.OidcConfiguration;

public class AllowedTokenExpirationClockSkew
extends OidcProperty {
    private int valueSeconds;

    @DataBoundConstructor
    public AllowedTokenExpirationClockSkew(int valueSeconds) {
        this.valueSeconds = valueSeconds;
    }

    public int getValueSeconds() {
        return this.valueSeconds;
    }

    @Override
    @NonNull
    public OidcPropertyExecution newExecution(@NonNull OicServerConfiguration serverConfiguration) {
        return new ExecutionImpl(this.valueSeconds);
    }

    private record ExecutionImpl(int valueSeconds) implements OidcPropertyExecution
    {
        @Override
        public void customizeConfiguration(@NonNull OidcConfiguration configuration) {
            configuration.setMaxClockSkew(this.valueSeconds);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends OidcPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.AllowedTokenExpirationClockSkew_DisplayName();
        }

        @Override
        public void getFallbackConfiguration(@NonNull OicServerConfiguration serverConfiguration, @NonNull OidcConfiguration configuration) {
            configuration.setMaxClockSkew(this.getDefaultValueSeconds());
        }

        public int getDefaultValueSeconds() {
            return 60;
        }
    }
}

