/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import com.nimbusds.jose.util.DefaultResourceRetriever;
import hudson.ProxyConfiguration;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import jenkins.security.FIPS140;
import jenkins.util.SystemProperties;
import org.jenkinsci.plugins.oic.ssl.IgnoringHostNameVerifier;
import org.jenkinsci.plugins.oic.ssl.TLSUtils;

class ProxyAwareResourceRetriever
extends DefaultResourceRetriever {
    private static final int CONNECTION_TIMEOUT_MS = SystemProperties.getInteger((String)"OIC_CONNECTION_TIMEOUT_MS", (Integer)2000);
    private static final int READ_TIMEOUT_MS = SystemProperties.getInteger((String)"OIC_CONNECTION_READ_TIMEOUT_MS", (Integer)5000);
    private static final int SIZE_LIMIT = SystemProperties.getInteger((String)"OIC_CONNECTION_SIZE_LIMIT", (Integer)0);
    private final boolean disableTLSValidation;

    private ProxyAwareResourceRetriever(boolean disableTLSValidation) throws KeyManagementException, NoSuchAlgorithmException {
        super(CONNECTION_TIMEOUT_MS, READ_TIMEOUT_MS, SIZE_LIMIT, true, disableTLSValidation ? TLSUtils.createAnythingGoesSSLSocketFactory() : null);
        this.disableTLSValidation = disableTLSValidation;
        this.setHeaders(Map.of("Accept", List.of("application/json")));
    }

    protected HttpURLConnection openHTTPConnection(URL url) throws IOException {
        HttpURLConnection con = (HttpURLConnection)ProxyConfiguration.open((URL)url);
        if (this.disableTLSValidation && con instanceof HttpsURLConnection) {
            ((HttpsURLConnection)con).setHostnameVerifier(IgnoringHostNameVerifier.INSTANCE);
        }
        return con;
    }

    static ProxyAwareResourceRetriever createProxyAwareResourceRetriver(boolean disableTLSValidation) {
        if (FIPS140.useCompliantAlgorithms() && disableTLSValidation) {
            throw new IllegalArgumentException("Can not disable TLS validation when running Jenkins in FIPS 140 mode");
        }
        try {
            return new ProxyAwareResourceRetriever(disableTLSValidation);
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Could not construct the ProxyAwareResourceRetriver", e);
        }
    }
}

