/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.oic;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;

public abstract class AbstractKeyValueDescribable<T extends AbstractKeyValueDescribable<T>>
extends AbstractDescribableImpl<T> {
    @NonNull
    private final String key;
    @NonNull
    private final String value;

    public AbstractKeyValueDescribable(String key, String value) throws Descriptor.FormException {
        this(key, value, false);
    }

    public AbstractKeyValueDescribable(String key, String value, boolean allowBlankValue) throws Descriptor.FormException {
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new Descriptor.FormException("key must not be blank", "key");
        }
        if (!allowBlankValue && StringUtils.isBlank((CharSequence)value)) {
            throw new Descriptor.FormException("value must not be blank", "value");
        }
        FormValidation keyValidation = this.getDescriptor().doCheckKey(key);
        if (keyValidation.kind == FormValidation.Kind.ERROR) {
            throw new Descriptor.FormException(keyValidation.getMessage(), "key");
        }
        FormValidation valueValidation = this.getDescriptor().doCheckValue(value);
        if (valueValidation.kind == FormValidation.Kind.ERROR) {
            throw new Descriptor.FormException(valueValidation.getMessage(), "value");
        }
        this.key = key.trim();
        this.value = value == null ? "" : value.trim();
    }

    @NonNull
    public String getKey() {
        return this.key;
    }

    @NonNull
    public String getValue() {
        return this.value;
    }

    public DescriptorImpl<T> getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static abstract class DescriptorImpl<T extends AbstractKeyValueDescribable<T>>
    extends Descriptor<T> {
        public abstract FormValidation doCheckKey(@QueryParameter String var1);

        public abstract FormValidation doCheckValue(@QueryParameter String var1);
    }
}

